/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import java.util.Arrays;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.OfflinePlayer;

@Name(value="Online/Offline Players/Members of a Faction/Kingdom/Guild")
@Description(value="Retrieve all the online/offline players/members of a given factions/kingdom/guild")
@BSyntax(syntax={"[(every|all)] [of] [the] (1\u00a6online|2\u00a6offline) (player|member)[s] of [the] [(faction|kingdom|guild)] %conquerfaction%", "%conquerfaction%'s (0\u00a6online|1\u00a6offline) (player|member)[s]"}, bind={"factions"})
@Examples(value={@Example(value={"message \"Offline: %offline members of faction of player%\"", "message \"Online: %online members of faction of player%\""})})
public class ExprOfflineOnlineMembersOfFaction
extends ASAExpression<OfflinePlayer> {
    public OfflinePlayer[] getValues() throws NullExpressionException {
        Boolean online = this.getParseResult().mark == 0;
        ConquerFaction faction = (ConquerFaction)this.exp().get("factions");
        this.assertNotNull(faction, "Faction given is null");
        return (OfflinePlayer[])Arrays.stream(faction.getPlayers()).filter(offlinePlayer -> online.booleanValue() == offlinePlayer.isOnline()).toArray(OfflinePlayer[]::new);
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<OfflinePlayer>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.ADD};
            }

            public void change(OfflinePlayer[] offlinePlayers) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprOfflineOnlineMembersOfFaction.this.exp().get("factions");
                ExprOfflineOnlineMembersOfFaction.this.assertNotNull(faction, "Faction given to add a player to is null");
                faction.addPlayer(offlinePlayers[0]);
            }
        }, new ASAChanger<OfflinePlayer>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.REMOVE};
            }

            public void change(OfflinePlayer[] offlinePlayers) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprOfflineOnlineMembersOfFaction.this.exp().get("factions");
                ExprOfflineOnlineMembersOfFaction.this.assertNotNull(faction, "Faction given to remove a player from is null");
                faction.removePlayer(offlinePlayers[0]);
            }
        }};
    }
}

