/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;

@Name(value="Name of Faction/Kingdom/Guild")
@Description(value="Retrieve the name of a factions/kingdom/guild")
@BSyntax(syntax={"[the] name [of] [the] [(faction|kingdom|guild)] %conquerfaction%", "[(faction|kingdom|guild)] %conquerfaction%'s name"}, bind={"faction"})
@Examples(value={@Example(value={"#You don't even need `name of`, it automatically prints out the name if used in string form", "message \"The name of your faction is %name of faction of player%\""})})
public class ExprNameOfFaction
extends ASAExpression<String> {
    @Override
    public String getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getName();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(String[] objects) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprNameOfFaction.this.exp().get("faction");
                ExprNameOfFaction.this.assertNotNull(faction, "Faction given to set the name of is null");
                faction.setName(objects[0]);
            }
        }};
    }
}

