/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;

@Name(value="MOTD of Faction/Kingdom/Guild")
@Description(value="Retrieve the MOTD (message of the day) of a factions/kingdom/guild")
@BSyntax(syntax={"[the] motd [of] [the] [(faction|kingdom|guild)] %conquerfaction%", "[(faction|kingdom|guild)] %conquerfaction%'s motd"}, bind={"factions"})
@Examples(value={@Example(value={"message \"The MOTD of your faction is %motd of faction of player%\""})})
public class ExprMotdOfFaction
extends ASAExpression<String> {
    @Override
    public String getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("factions");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getMotd();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(String[] objects) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprMotdOfFaction.this.exp().get("factions");
                ExprMotdOfFaction.this.assertNotNull(faction, "Faction given to set the MOTD of is null");
                faction.setMotd(objects[0]);
            }
        }};
    }
}

