/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.OfflinePlayer;

@Name(value="Leader of Faction/Kingdom/Guild")
@Description(value="Retrieve the leader of a given factions/kingdom/guild")
@BSyntax(syntax={"[the] leader of [the] [(faction|kingdom|guild)] %conquerfaction%", "%conquerfaction%'s leader"}, bind={"faction"})
@Examples(value={@Example(value={"message \"The leader of your faction is %leader of faction of player%\""})})
public class ExprLeaderOfFaction
extends ASAExpression<OfflinePlayer> {
    @Override
    public OfflinePlayer getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getLeader();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<OfflinePlayer>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(OfflinePlayer[] offlinePlayers) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprLeaderOfFaction.this.exp().get("faction");
                ExprLeaderOfFaction.this.assertNotNull(faction, "Faction given to set the leader of is null");
                faction.setLeader(offlinePlayers[0]);
            }
        }};
    }
}

