/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;

@Name(value="Identifier (ID) of Faction/Kingdom/Guild")
@Description(value="Retrieve the identifier (ID) of a factions/kingdom/guild")
@BSyntax(syntax={"[the] id[entifier] [of] [the] [(faction|kingdom|guild)] %conquerfaction%", "[(faction|kingdom|guild)] %conquerfaction%'s id[entifier]"}, bind={"faction"})
@Examples(value={@Example(value={"message \"The id (identifier) of your faction is %identifier of faction of player%\""})})
public class ExprIdentifierOfFaction
extends ASAExpression<String> {
    @Override
    public String getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getIdentifier();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(String[] objects) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprIdentifierOfFaction.this.exp().get("faction");
                ExprIdentifierOfFaction.this.assertNotNull(faction, "Faction given to set the identifier of is null");
                faction.setIdentifier(objects[0]);
            }
        }};
    }
}

