/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.Location;

@Name(value="Home of Faction/Kingdom/Guild")
@Description(value="Retrieve the home (location) of a factions/kingdom/guild")
@BSyntax(syntax={"[the] home [location] [of] [the] [(faction|kingdom|guild)] %conquerfaction%", "[(faction|kingdom|guild)] %conquerfaction%'s home [location]"}, bind={"factions"})
@Examples(value={@Example(value={"command /factionhome:", "\ttrigger:", "\t\tteleport player to home of faction of player"})})
public class ExprHomeOfFaction
extends ASAExpression<Location> {
    @Override
    public Location getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("factions");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getHome();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<Location>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(Location[] objects) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprHomeOfFaction.this.exp().get("factions");
                ExprHomeOfFaction.this.assertNotNull(faction, "Faction given to set the home of is null");
                faction.setHome(objects[0]);
            }
        }};
    }
}

