/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionsPlugin;

@Name(value="Faction/Kingdom/Guild with Name/Identifier")
@Description(value="Retrieve a factions/kingdom/guild by its name/identifier")
@BSyntax(syntax={"[the] (faction|kingdom|guild) (with|by) [(name|id[entifier])] %string%"}, bind={"identifier"})
@Examples(value={@Example(value={"command /factionbyname <text>", "\ttrigger:", "\t\tset {_fac} to faction by name arg-1", "\t\tif {_fac} is not set:", "\t\t\tmessage \"Faction not found\"", "\t\t\tstop trigger", "\t\tmessage \"Faction found!\""})})
public class ExprFactionByName
extends ASAExpression<ConquerFaction> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public ConquerFaction getValue() throws NullExpressionException {
        String identifier = (String)this.exp().get("identifier");
        this.assertNotNull(identifier, "Name/Identifier given is null");
        return this.factionsPlugin.getByName(identifier);
    }
}

