/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionsPlugin;

@Name(value="Faction/Kingdom/Guild At Claim")
@Description(value="Retrieve the faction/kingdom/guild at a given claim")
@BSyntax(syntax={"[the] (faction|kingdom|guild) at claim %conquerclaim%"}, bind={"claim"})
@Examples(value={@Example(value={"message \"Faction at your claim: %faction at claim at player%\""})})
public class ExprFactionAtClaim
extends ASAExpression<ConquerFaction> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public ConquerFaction getValue() throws NullExpressionException {
        Claim claim = (Claim)this.exp().get("claim");
        this.assertNotNull(claim, "Claim given is null");
        return this.factionsPlugin.getFaction(claim);
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<ConquerFaction>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(ConquerFaction[] factions) throws NullExpressionException {
                Claim claim = (Claim)ExprFactionAtClaim.this.exp().get("claim");
                ExprFactionAtClaim.this.assertNotNull(claim, "Claim given to set faction of is null");
                claim.setFaction(factions[0]);
            }
        }, new ASAChanger<ConquerFaction>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET, Changer.ChangeMode.REMOVE_ALL};
            }

            public void change(ConquerFaction[] factions) throws NullExpressionException {
                Claim claim = (Claim)ExprFactionAtClaim.this.exp().get("claim");
                ExprFactionAtClaim.this.assertNotNull(claim, "Claim given to reset faction of is null");
                claim.resetFaction();
            }
        }};
    }
}

