/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;

@Name(value="Description of Faction/Kingdom/Guild")
@Description(value="Retrieve the description of a factions/kingdom/guild")
@BSyntax(syntax={"[the] description [of] [the] [(faction|kingdom|guild)] %conquerfaction%", "[(faction|kingdom|guild)] %conquerfaction%'s description"}, bind={"faction"})
@Examples(value={@Example(value={"message \"The the description of your faction is %description of faction at player%\""})})
public class ExprDescriptionOfFaction
extends ASAExpression<String> {
    @Override
    public String getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getDescription();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(String[] objects) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprDescriptionOfFaction.this.exp().get("faction");
                ExprDescriptionOfFaction.this.assertNotNull(faction, "Faction given to set the description of is null");
                faction.setDescription(objects[0]);
            }
        }};
    }
}

