/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import java.util.Date;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;

@Name(value="Creation Time of Faction/Kingdom/Guild")
@Description(value="Retrieve the creation time of a given factions/kingdom/guild")
@BSyntax(syntax={"[the] (time|date) [when] %conquerfaction% was created", "%conquerfaction%'s (time|date) created", "[the] creat(ed|ion) (time|date) of %conquerfaction%", "%conquerfaction%'s creat(ed|ion) (time|date)"}, bind={"faction"})
@Examples(value={@Example(value={"message \"Your faction was created on %creation date of faction of player%\""})})
public class ExprCreationTimeOfFaction
extends ASAExpression<ch.njol.skript.util.Date> {
    @Override
    public ch.njol.skript.util.Date getValue() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return new ch.njol.skript.util.Date(faction.getCreationDate().getTime());
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<ch.njol.skript.util.Date>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(ch.njol.skript.util.Date[] dates) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprCreationTimeOfFaction.this.exp().get("faction");
                ExprCreationTimeOfFaction.this.assertNotNull(faction, "Faction given to set the creation time of is null");
                faction.setCreationDate(new Date(dates[0].getTimestamp()));
            }
        }};
    }
}

