/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import ch.njol.skript.classes.Changer;
import java.util.Arrays;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.OfflinePlayer;

@Name(value="All Players/Members of Faction/Kingdom/Guild")
@Description(value="Retrieve all the players/members of a given factions/kingdom/guild")
@BSyntax(syntax={"[all] [the] (member|player)[s] (of|in|for|from) [(faction|kingdom|guild)] %conquerfaction%", "%conquerfaction%'s [(faction|kingdom|guild)] (member|player)[s]"}, bind={"faction"})
@Examples(value={@Example(value={"message \"All the members of your faction %all members of faction of player%\""})})
public class ExprAllMembersOfFaction
extends ASAExpression<OfflinePlayer> {
    public OfflinePlayer[] getValues() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("faction");
        this.assertNotNull(faction, "Faction given is null");
        return faction.getPlayers();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<OfflinePlayer>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.REMOVE};
            }

            public void change(OfflinePlayer[] players) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprAllMembersOfFaction.this.exp().get("factions");
                ExprAllMembersOfFaction.this.assertNotNull(faction, "Faction given is null");
                Arrays.stream(players).forEach(faction::removePlayer);
            }
        }, new ASAChanger<OfflinePlayer>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.ADD};
            }

            public void change(OfflinePlayer[] players) throws NullExpressionException {
                ConquerFaction faction = (ConquerFaction)ExprAllMembersOfFaction.this.exp().get("factions");
                ExprAllMembersOfFaction.this.assertNotNull(faction, "Faction given is null");
                Arrays.stream(players).forEach(faction::addPlayer);
            }
        }};
    }
}

