/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionsPlugin;

@Name(value="All Claims Of Faction/Kingdom/Guild")
@Description(value="Retrieve all the claims/land/region of a given factions/kingdom/guild")
@BSyntax(syntax={"[all] [the] (claims|land|regions) (of|for) [(faction|kingdom|guild)] %conquerfaction%", "%conquerfaction%'[s] (claims|land|regions)"}, bind={"factions"})
@Examples(value={@Example(value={"loop all claims of faction of player:", "\tbroadcast \"Claim: %loop-claim%\""})})
public class ExprAllClaimsOfFaction
extends ASAExpression<Claim> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    public Claim[] getValues() throws NullExpressionException {
        ConquerFaction faction = (ConquerFaction)this.exp().get("factions");
        this.assertNotNull(faction, "Faction given is null");
        return this.factionsPlugin.getClaims(faction);
    }
}

