/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.claims;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.Location;

@Name(value="Claim At Location")
@Description(value="Retrieve the claim at a given location")
@BSyntax(syntax={"[the] claim at %location%"}, bind={"location"})
@Examples(value={@Example(value={"#Skript can automatically convert the player to a location via a converter", "set {_claim} to the claim at the player"})})
public class ExprClaimAtLocation
extends ASAExpression<Claim> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Claim getValue() throws NullExpressionException {
        Location location = (Location)this.exp().get("location");
        this.assertNotNull(location, "Location given is null");
        return this.factionsPlugin.getClaim(location);
    }
}

