/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.claims;

import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.Claim;
import org.bukkit.Chunk;

@Name(value="Chunk of Claim")
@Description(value="Retrieve the chunk of a given claim. Will return <none> (null) if the claim is not represented by a chunk (i.e plugins which have claims not bounded to chunks).")
@BSyntax(syntax={"chunk of %conquerclaim%"}, bind={"claim"})
@Examples(value={@Example(value={"broadcast \"The chunk of the claim at the player is %chunk of claim at player%\""})})
public class ExprChunkOfClaim
extends ASAExpression<Chunk> {
    @Override
    public Chunk getValue() throws NullExpressionException {
        Claim claim = (Claim)this.exp().get("claim");
        this.assertNotNull(claim, "Claim given is null");
        if (claim.getRepresentationObject() instanceof Chunk) {
            return (Chunk)claim.getRepresentationObject();
        }
        return null;
    }
}

