/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.PowerChangeable;
import me.andrew28.addons.conquer.api.PowerHolder;

@Name(value="Power Of Player/Faction/Kingdom/Guild")
@Description(value="Retrieve the power of a player/kingdom/guild")
@BSyntax(syntax={"[the] power [level] [of] [the] [(faction|kingdom|guild|player)] %powerholder%", "[(faction|kingdom|guild|player)]  %powerholder%'s power [level]"}, bind={"powerholder"})
@Examples(value={@Example(value={"message \"Your Power: %power of player%\"", "message \"Faction Power: %power of faction of player%\""})})
public class ExprPowerOfPowerHolder
extends ASAExpression<Double> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Double getValue() throws NullExpressionException {
        PowerHolder powerHolder = (PowerHolder)this.exp().get("powerholder");
        this.assertNotNull(powerHolder, "Power holder given is null");
        return powerHolder.getPower();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<Double>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(Double[] doubles) throws NullExpressionException {
                Object object = ExprPowerOfPowerHolder.this.exp().get("powerholder");
                ExprPowerOfPowerHolder.this.assertNotNull(object, "Given powerchangeable to set the power of is null");
                if (!(object instanceof PowerChangeable)) {
                    Skript.error((String)"Cannot change power of given object because object is not a PowerChangeable");
                    return;
                }
                PowerChangeable powerChangeable = (PowerChangeable)object;
                powerChangeable.setPower(doubles[0]);
            }
        }, new ASAChanger<Double>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET};
            }

            public void change(Double[] doubles) throws NullExpressionException {
                Object object = ExprPowerOfPowerHolder.this.exp().get("powerholder");
                ExprPowerOfPowerHolder.this.assertNotNull(object, "Given powerchangeable to reset the power of is null");
                if (!(object instanceof PowerChangeable)) {
                    Skript.error((String)"Cannot reset power of given object because object is not a PowerChangeable");
                    return;
                }
                PowerChangeable powerChangeable = (PowerChangeable)object;
                powerChangeable.resetPower();
            }
        }};
    }
}

