/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.PowerChangeable;
import me.andrew28.addons.conquer.api.PowerHolder;

@Name(value="Power Boost of Player/Faction/Kingdom/Guild")
@Description(value="Retrieve the power boost of a given player/faction/kingdom/guild")
@BSyntax(syntax={"[the] power[ ]boost [level] [of] [the] [(faction|kingdom|guild|player)] %powerholder%", "[the] [(faction|kingdom|guild|player)] %powerholder%'s power[ ]boost [level]"}, bind={"powerholder"})
@Examples(value={@Example(value={"message \"Your Power Boost: %power boost of player%\"", "message \"Faction Power Boost: %power boost of faction of player%\""})})
public class ExprPowerBoostOfPowerHolder
extends ASAExpression<Double> {
    @Override
    public Double getValue() throws NullExpressionException {
        PowerHolder powerHolder = (PowerHolder)this.exp().get("powerholder");
        this.assertNotNull(powerHolder, "Power holder given is null");
        return powerHolder.getPowerBoost();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<Double>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(Double[] doubles) throws NullExpressionException {
                Object object = ExprPowerBoostOfPowerHolder.this.exp().get("powerholder");
                ExprPowerBoostOfPowerHolder.this.assertNotNull(object, "Power Changeable given to the power boost of is null");
                if (!(object instanceof PowerChangeable)) {
                    Skript.error((String)"Cannot set power boost of given object because object is not a PowerChangeable");
                    return;
                }
                PowerChangeable powerChangeable = (PowerChangeable)object;
                powerChangeable.setPowerBoost(doubles[0]);
            }
        }, new ASAChanger<Double>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET};
            }

            public void change(Double[] doubles) throws NullExpressionException {
                Object object = ExprPowerBoostOfPowerHolder.this.exp().get("powerholder");
                ExprPowerBoostOfPowerHolder.this.assertNotNull(object, "Power Changeable given to the power boost of is null");
                if (!(object instanceof PowerChangeable)) {
                    Skript.error((String)"Cannot reset power boost of given object because object is not a PowerChangeable");
                    return;
                }
                PowerChangeable powerChangeable = (PowerChangeable)object;
                powerChangeable.resetPowerBoost();
            }
        }};
    }
}

