/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions.players;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASACondition;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Player Is Automatically Claiming")
@Description(value="Passes if the player is automatically claiming land")
@BSyntax(syntax={"%player% (0\u00a6is|1\u00a6is not) auto[(matical[ly])] claim[ing] [land]", "%player%'s auto[matic] claim[ing] (state|mode) (0\u00a6is|1\u00a6is not) on"}, bind={"player"})
@Examples(value={@Example(value={"if player is automatically claiming land:", "\tmessage \"You are automatically claiming land!\"", "else:", "\tmessage \"You are not automatically claiming land :(\""})})
public class CondPlayerIsAutoClaiming
extends ASACondition {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public boolean check() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        boolean invert = this.getParseResult().mark == 1;
        boolean autoClaiming = this.factionsPlugin.getConquerPlayer(player).isAutoClaiming();
        return invert != autoClaiming;
    }
}

