/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions.players;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASACondition;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Player Has Faction/Kingdom/Guild")
@Description(value="Passes if the given player is in a faction/kingdom/guild")
@BSyntax(syntax={"%player% (0\u00a6has|1\u00a6(doesn't have|does not have)) [a] (faction|kingdom|guild)", "%player% (0\u00a6in|1\u00a6(isn't|is not)) [a] (faction|kingdom|guild)"}, bind={"player"})
@Examples(value={@Example(value={"if player has a faction:", "\tmessage \"You have a faction!\"", "else:", "\tmessage \"You don't have a faction :(\""})})
public class CondPlayerHasFaction
extends ASACondition {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public boolean check() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        Boolean invert = this.getParseResult().mark == 1;
        return invert.booleanValue() != this.factionsPlugin.getConquerPlayer(player).hasFaction();
    }
}

