/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions.claims;

import me.andrew28.addons.conquer.addoncore.ASACondition;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.Claim;

@Name(value="Claim is a Safe/War Zone")
@Description(value="Passes if the given claim is a safe/war (pick one) zone")
@BSyntax(syntax={"%conquerclaim% is [a] (0\u00a6safe|1\u00a6war) (area|zone)"}, bind={"claim"})
@Examples(value={@Example(value={"if claim at player is a safe zone:", "\tmessage \"You are in a safe zone!\"", "else if claim at player is a war zone:", "\tmessage \"You are in a war zone!\"", "else:", "\tmessage \"You are in the wilderness or a faction!\""})})
public class CondClaimIsSafeWarZone
extends ASACondition {
    @Override
    public boolean check() throws NullExpressionException {
        Claim claim = (Claim)this.exp().get("claim");
        this.assertNotNull(claim, "Claim given is null");
        return this.getParseResult().mark == 0 ? claim.isSafeZone() : claim.isWarZone();
    }
}

