/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.factionsuuid;

import ch.njol.skript.Skript;
import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.struct.Role;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import me.andrew28.addons.conquer.addoncore.Addon;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.PowerChangeable;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationChangeEvent;
import me.andrew28.addons.conquer.factionsuuid.FactionsUUIDImplEventWrapperListener;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class FactionsUUIDImpl
implements FactionsPlugin {
    private Factions factions;
    private FPlayers fPlayers;
    private Board board;

    @Override
    public boolean canBeUsed() {
        return Bukkit.getPluginManager().getPlugin("Factions") != null && Bukkit.getPluginManager().getPlugin("Factions").getDescription().getAuthors().contains("drtshock");
    }

    @Override
    public void initialize() {
        this.factions = Factions.getInstance();
        this.fPlayers = FPlayers.getInstance();
        this.board = Board.getInstance();
    }

    @Override
    public void initializeSkriptComponents(Addon addon) {
    }

    @Override
    public Listener getEventWrapperListener() {
        return new FactionsUUIDImplEventWrapperListener();
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.factions != null && this.fPlayers != null && this.board != null;
    }

    @Override
    public ConquerFaction[] getAll() {
        return (ConquerFaction[])this.factions.getAllFactions().stream().map(this::getFactionsUUIDFaction).toArray(ConquerFaction[]::new);
    }

    @Override
    public ConquerFaction getAtLocation(Location location) {
        return this.getFactionsUUIDFaction(this.board.getFactionAt(this.getFLocationFromLocation(location)));
    }

    @Override
    public ConquerFaction getByName(String name) {
        return this.getFactionsUUIDFaction(this.factions.getByTag(name));
    }

    @Override
    public ConquerFaction getFaction(Claim claim) {
        return this.getFactionsUUIDFaction(this.board.getFactionAt(((FactionsUUIDClaim)claim).getFLocation()));
    }

    @Override
    public ConquerPlayer getConquerPlayer(Player player) {
        return this.getFactionsUUIDPlayer(player);
    }

    @Override
    public Claim getClaim(Location location) {
        return this.getFactionsUUIDClaimFromChunk(location.getChunk());
    }

    @Override
    public Claim[] getClaims(ConquerFaction faction) {
        return (Claim[])this.board.getAllClaims(this.getFactionFromConquerFaction(faction)).stream().map(this::getFactionsUUIDClaimFromFLocation).toArray(Claim[]::new);
    }

    @Override
    public void claim(ConquerFaction faction, Location location) {
        this.board.setFactionAt(this.getFactionFromConquerFaction(faction), this.getFLocationFromLocation(location));
    }

    @Override
    public void removeClaim(Location location) {
        this.board.setFactionAt(this.factions.getWilderness(), this.getFLocationFromLocation(location));
    }

    @Override
    public Claim deserializeClaim(Fields f) throws StreamCorruptedException {
        World w = Bukkit.getWorld((String)((String)f.getObject("world")));
        Integer x = (Integer)f.getObject("X");
        Integer z = (Integer)f.getObject("Z");
        return this.getFactionsUUIDClaimFromChunk(w.getChunkAt(x.intValue(), z.intValue()));
    }

    @Override
    public ConquerFaction deserializeFaction(Fields f) throws StreamCorruptedException {
        return this.getFactionsUUIDFaction(this.factions.getFactionById((String)f.getObject("id")));
    }

    public FLocation getFLocationFromLocation(Location location) {
        Chunk chunk = location.getChunk();
        return new FLocation(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public Location getLocationFromFLocation(FLocation fLocation) {
        return new Location(fLocation.getWorld(), (double)(fLocation.getX() * 16L), 0.0, (double)fLocation.getZ());
    }

    public Chunk getChunkFromFLocation(FLocation fLocation) {
        return this.getLocationFromFLocation(fLocation).getChunk();
    }

    public FLocation getFLocationFromChunk(Chunk chunk) {
        return this.getFLocationFromLocation(new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16)));
    }

    public FactionsUUIDClaim getFactionsUUIDClaimFromFLocation(FLocation fLocation) {
        return this.getFactionsUUIDClaimFromChunk(this.getChunkFromFLocation(fLocation));
    }

    public FactionsUUIDClaim getFactionsUUIDClaimFromChunk(Chunk chunk) {
        return new FactionsUUIDClaim(this, chunk);
    }

    public FactionsUUIDPlayer getFactionsUUIDPlayer(Player player) {
        return new FactionsUUIDPlayer(this, player);
    }

    public FactionsUUIDFaction getFactionsUUIDFaction(Faction faction) {
        if (faction == null || faction.isWarZone() || faction.isSafeZone() || faction.isWilderness()) {
            return null;
        }
        return new FactionsUUIDFaction(this, faction);
    }

    public Faction getFactionFromConquerFaction(ConquerFaction conquerFaction) {
        return this.factions.getByTag(conquerFaction.getName());
    }

    public static class FactionsUUIDFaction
    extends ConquerFaction {
        private static final String NO_MOTD_SUPPORT_WARNING = "FactionsUUID does not support MOTD, so MOTD related expressions will return null (<none>)";
        private Faction faction;
        private FactionsUUIDImpl factionsUUIDImpl;

        public FactionsUUIDFaction(FactionsUUIDImpl factionsUUIDImpl, Faction faction) {
            this.faction = faction;
            this.factionsUUIDImpl = factionsUUIDImpl;
        }

        @Override
        public String getName() {
            return this.faction.getTag();
        }

        @Override
        public void setName(String name) {
            this.faction.setTag(name);
        }

        @Override
        public Fields serialize() {
            Fields f = new Fields();
            f.putObject("id", (Object)this.faction.getId());
            return f;
        }

        @Override
        public ConquerFaction.FactionCommandSender getFactionCommandSender() {
            return new ConquerFaction.FactionCommandSender(){

                public void sendMessage(String message) {
                    faction.sendMessage(message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    faction.sendMessage(Arrays.asList(messages));
                }
            };
        }

        @Override
        public String getDescription() {
            return this.faction.getDescription();
        }

        @Override
        public void setDescription(String description) {
            this.faction.setDescription(description);
        }

        @Override
        public String getMotd() {
            Skript.warning((String)NO_MOTD_SUPPORT_WARNING);
            return null;
        }

        @Override
        public void setMotd(String motd) {
            Skript.warning((String)NO_MOTD_SUPPORT_WARNING);
        }

        @Override
        public String getIdentifier() {
            return this.faction.getId();
        }

        @Override
        public void setIdentifier(String identifier) {
            this.faction.setId(identifier);
        }

        @Override
        public Date getCreationDate() {
            return new Date(this.faction.getFoundedDate());
        }

        @Override
        public void setCreationDate(Date date) {
            this.faction.setFoundedDate(date.getTime());
        }

        @Override
        public double getPowerBoost() {
            return this.faction.getPowerBoost();
        }

        @Override
        public void setPowerBoost(Double powerBoost) {
            this.faction.setPowerBoost(powerBoost.doubleValue());
        }

        @Override
        public double getPower() {
            return this.faction.getPower();
        }

        @Override
        public double getMaximumPower() {
            return this.faction.getPowerMax();
        }

        @Override
        public OfflinePlayer getLeader() {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.faction.getFPlayerAdmin().getId()));
        }

        @Override
        public void setLeader(OfflinePlayer leader) {
            this.getFPLayerFromOfflinePlayer(leader).setRole(Role.ADMIN);
        }

        @Override
        public Location getHome() {
            return this.faction.getHome();
        }

        @Override
        public void setHome(Location location) {
            this.faction.setHome(location);
        }

        @Override
        public OfflinePlayer[] getPlayers() {
            return (OfflinePlayer[])this.faction.getFPlayers().stream().map(this::getOfflinePlayerFromFPlayer).toArray(OfflinePlayer[]::new);
        }

        @Override
        public void addPlayer(OfflinePlayer offlinePlayer) {
            this.faction.addFPlayer(this.getFPLayerFromOfflinePlayer(offlinePlayer));
        }

        @Override
        public void removePlayer(OfflinePlayer offlinePlayer) {
            this.faction.removeFPlayer(this.getFPLayerFromOfflinePlayer(offlinePlayer));
        }

        @Override
        public ConquerFactionRelationChangeEvent.Relation getRelationShipTo(ConquerFaction otherFaction) {
            Faction factionsFaction = this.faction;
            Faction factionsFactionTarget = ((FactionsUUIDFaction)otherFaction).faction;
            ConquerFactionRelationChangeEvent.Relation relation = ConquerFactionRelationChangeEvent.Relation.OTHER;
            switch (factionsFaction.getRelationTo((RelationParticipator)factionsFactionTarget)) {
                case ALLY: {
                    relation = ConquerFactionRelationChangeEvent.Relation.ALLY;
                    break;
                }
                case TRUCE: {
                    relation = ConquerFactionRelationChangeEvent.Relation.TRUCE;
                    break;
                }
                case NEUTRAL: {
                    relation = ConquerFactionRelationChangeEvent.Relation.NEUTRAL;
                    break;
                }
                case ENEMY: {
                    relation = ConquerFactionRelationChangeEvent.Relation.ENEMY;
                }
            }
            return relation;
        }

        public OfflinePlayer getOfflinePlayerFromFPlayer(FPlayer fPlayer) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(fPlayer.getId()));
        }

        public FPlayer getFPLayerFromOfflinePlayer(OfflinePlayer offlinePlayer) {
            return this.factionsUUIDImpl.fPlayers.getByOfflinePlayer(offlinePlayer);
        }
    }

    public static class FactionsUUIDPlayer
    extends ConquerPlayer
    implements PowerChangeable {
        private FactionsUUIDImpl factionsUUIDImpl;
        private FPlayer fPlayer;

        public FactionsUUIDPlayer(FactionsUUIDImpl factionsUUIDImpl, Player player) {
            super(player);
            this.factionsUUIDImpl = factionsUUIDImpl;
            this.fPlayer = this.factionsUUIDImpl.fPlayers.getByPlayer(player);
        }

        @Override
        public boolean hasFaction() {
            return this.fPlayer.getFaction() != null;
        }

        @Override
        public ConquerFaction getFaction() {
            return this.factionsUUIDImpl.getFactionsUUIDFaction(this.fPlayer.getFaction());
        }

        @Override
        public void setFaction(ConquerFaction faction) {
            this.fPlayer.setFaction(this.factionsUUIDImpl.getFactionFromConquerFaction(faction));
        }

        @Override
        public void resetFaction() {
            this.fPlayer.setFaction(this.factionsUUIDImpl.factions.getWilderness());
        }

        @Override
        public boolean isAutoClaiming() {
            return this.fPlayer.getAutoClaimFor() != null;
        }

        @Override
        public void setAutoClaiming(Boolean autoClaiming) {
            this.fPlayer.setAutoClaimFor(this.factionsUUIDImpl.getFactionFromConquerFaction(this.getFaction()));
        }

        @Override
        public Date getLastActivity() {
            return new Date(this.fPlayer.getLastLoginTime());
        }

        @Override
        public void setLastActivity(Date date) {
            this.fPlayer.setLastLoginTime(date.getTime());
        }

        @Override
        public me.andrew28.addons.conquer.api.Role getRole() {
            return me.andrew28.addons.conquer.api.Role.valueOf(this.fPlayer.getRole().name());
        }

        @Override
        public void setRole(me.andrew28.addons.conquer.api.Role role) {
            this.fPlayer.setRole(Role.valueOf((String)role.name()));
        }

        @Override
        public String getTitle() {
            return this.fPlayer.getTitle();
        }

        @Override
        public void setTitle(String title) {
            this.fPlayer.setTitle(title);
        }

        @Override
        public void resetTitle() {
            this.fPlayer.setTitle("");
        }

        @Override
        public double getPowerBoost() {
            return this.fPlayer.getPowerBoost();
        }

        @Override
        public void setPowerBoost(double powerBoost) {
            this.fPlayer.getPowerBoost();
        }

        @Override
        public void resetPowerBoost() {
            this.fPlayer.setPowerBoost(0.0);
        }

        @Override
        public double getPower() {
            return this.fPlayer.getPower();
        }

        @Override
        public void setPower(double power) {
            this.fPlayer.alterPower(power);
        }

        @Override
        public void resetPower() {
            this.setPower(0.0);
        }

        @Override
        public double getMaximumPower() {
            return this.fPlayer.getPowerMax();
        }

        @Override
        public double getMinimumPower() {
            return this.fPlayer.getPowerMin();
        }

        @Override
        public boolean getAutomaticMapUpdateMode() {
            return this.fPlayer.isMapAutoUpdating();
        }

        @Override
        public void setAutomaticMapUpdateMode(Boolean automaticMapUpdateMode) {
            this.fPlayer.setMapAutoUpdating(automaticMapUpdateMode.booleanValue());
        }
    }

    public static class FactionsUUIDClaim
    extends Claim<Chunk> {
        private FactionsUUIDImpl factionsUUIDImpl;
        private Chunk chunk;
        private FLocation fLocation;

        public FactionsUUIDClaim(FactionsUUIDImpl factionsUUIDImpl, Chunk chunk) {
            this.factionsUUIDImpl = factionsUUIDImpl;
            this.chunk = chunk;
            this.fLocation = factionsUUIDImpl.getFLocationFromChunk(chunk);
        }

        @Override
        public Chunk getRepresentationObject() {
            return this.chunk;
        }

        @Override
        public String representationObjectToString(Chunk representationObject, int flags) {
            return String.format("Conquer Claim%s: Chunk[x: %d, z: %d, world %s]", (flags & 1) != 0 ? "s" : "", representationObject.getX(), representationObject.getZ(), representationObject.getWorld().getName());
        }

        @Override
        public Fields serialize() {
            Fields f = new Fields();
            f.putObject("world", (Object)this.chunk.getWorld().getName());
            f.putPrimitive("X", (Object)this.chunk.getX());
            f.putPrimitive("Z", (Object)this.chunk.getZ());
            return f;
        }

        @Override
        public void setFaction(ConquerFaction faction) {
            this.factionsUUIDImpl.board.setFactionAt(this.factionsUUIDImpl.getFactionFromConquerFaction(faction), this.getFLocation());
        }

        @Override
        public void resetFaction() {
            this.factionsUUIDImpl.board.setFactionAt(this.factionsUUIDImpl.factions.getWilderness(), this.getFLocation());
        }

        @Override
        public boolean isSafeZone() {
            return this.factionsUUIDImpl.board.getFactionAt(this.getFLocation()).isSafeZone();
        }

        @Override
        public boolean isWarZone() {
            return this.factionsUUIDImpl.board.getFactionAt(this.getFLocation()).isWarZone();
        }

        public FLocation getFLocation() {
            return this.fLocation;
        }
    }
}

