/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.addoncore;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.andrew28.addons.conquer.addoncore.ElementSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntaxes;
import me.andrew28.addons.conquer.addoncore.annotations.Syntax;
import me.andrew28.addons.conquer.addoncore.annotations.Syntaxes;

public class SyntaxElementUtil {
    private static Map<String, ElementSyntax[]> syntaxes = new HashMap<String, ElementSyntax[]>();

    public static ElementSyntax[] getSyntax(Class<?> cls) {
        if (!syntaxes.containsKey(cls.getCanonicalName())) {
            ArrayList<ElementSyntax> elementSyntaxes = new ArrayList<ElementSyntax>();
            if (cls.isAnnotationPresent(BSyntaxes.class)) {
                BSyntaxes bSyntaxes = cls.getAnnotation(BSyntaxes.class);
                for (Annotation annotation : bSyntaxes.value()) {
                    ElementSyntax elementSyntax = new ElementSyntax(true, annotation.syntax());
                    elementSyntax.setBinds(annotation.bind());
                    elementSyntaxes.add(elementSyntax);
                }
            }
            if (cls.isAnnotationPresent(BSyntax.class)) {
                BSyntax bSyntax = cls.getAnnotation(BSyntax.class);
                ElementSyntax elementSyntax = new ElementSyntax(true, bSyntax.syntax());
                elementSyntax.setBinds(bSyntax.bind());
                elementSyntaxes.add(elementSyntax);
            }
            if (cls.isAnnotationPresent(Syntaxes.class)) {
                Syntaxes syntaxes = cls.getAnnotation(Syntaxes.class);
                for (Annotation annotation : syntaxes.value()) {
                    elementSyntaxes.add(new ElementSyntax(false, annotation.value()));
                }
            }
            if (cls.isAnnotationPresent(Syntax.class)) {
                Syntax syntax = cls.getAnnotation(Syntax.class);
                elementSyntaxes.add(new ElementSyntax(false, syntax.value()));
            }
            syntaxes.put(cls.getCanonicalName(), elementSyntaxes.toArray(new ElementSyntax[elementSyntaxes.size()]));
        }
        return syntaxes.get(cls.getCanonicalName());
    }
}

