/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.addoncore;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.registrations.EventValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import me.andrew28.addons.conquer.addoncore.ASACondition;
import me.andrew28.addons.conquer.addoncore.ASAConverter;
import me.andrew28.addons.conquer.addoncore.ASAEffect;
import me.andrew28.addons.conquer.addoncore.ASAElement;
import me.andrew28.addons.conquer.addoncore.ASAEvent;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.ASAPropertyExpression;
import me.andrew28.addons.conquer.addoncore.ASAType;
import me.andrew28.addons.conquer.addoncore.AutoRegisteringSkriptElement;
import me.andrew28.addons.conquer.addoncore.ClassFinder;
import me.andrew28.addons.conquer.addoncore.ElementSyntax;
import me.andrew28.addons.conquer.addoncore.EventValue;
import me.andrew28.addons.conquer.addoncore.Metrics;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.SyntaxElementUtil;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.DoNotDocument;
import me.andrew28.addons.conquer.addoncore.annotations.DoNotRegister;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.ExprType;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class Addon
extends JavaPlugin {
    private int loadedExpressions = 0;
    private int loadedTypes = 0;
    private int loadedEffects = 0;
    private int loadedConditions = 0;
    private int loadedEvents = 0;
    private List<ASAElement> asaElements = new ArrayList<ASAElement>();
    private List<AddonCommand> addonCommands = new ArrayList<AddonCommand>();
    private Metrics metrics;

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("Skript") == null) {
            this.getLogger().warning("Please install the plugin Skript (https://github.com/bensku/Skript/releases)");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.metrics = new Metrics(this);
        this.onAddonEnable();
    }

    public abstract void onAddonEnable();

    public void register(String pckg) {
        this.getLogger().info("Loading Skript Elements");
        Skript.registerAddon((JavaPlugin)this);
        this.registerClasses(pckg);
        this.getLogger().info(String.format("%d Expressions | %d Types | %d Effects | %d Conditions | %d Events", this.getLoadedExpressions(), this.getLoadedTypes(), this.getLoadedEffects(), this.getLoadedConditions(), this.getLoadedEvents()));
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public List<AddonCommand> getAddonCommands() {
        return this.addonCommands;
    }

    public void registerClass(Class<?> cls) {
        try {
            if (cls.isAnnotationPresent(DoNotRegister.class)) {
                return;
            }
            ElementSyntax[] elementSyntaxes = SyntaxElementUtil.getSyntax(cls);
            ArrayList<String> syntaxesList = new ArrayList<String>();
            for (ElementSyntax elementSyntax : elementSyntaxes) {
                syntaxesList.addAll(Arrays.asList(elementSyntax.getRawSyntaxes()));
            }
            String[] syntaxes = (String[])syntaxesList.stream().map(s -> "[" + this.getName().toLowerCase() + "] " + s).toArray(String[]::new);
            ExpressionType expressionType = null;
            if (cls.isAnnotationPresent(ExprType.class)) {
                expressionType = cls.getAnnotation(ExprType.class).value();
            }
            String name = cls.getCanonicalName();
            if (cls.isAnnotationPresent(Name.class)) {
                name = cls.getDeclaredAnnotation(Name.class).value();
            }
            String description = "";
            if (cls.isAnnotationPresent(Description.class)) {
                description = cls.getDeclaredAnnotation(Description.class).value();
            }
            String[][] examples = new String[0][0];
            if (cls.isAnnotationPresent(Examples.class) || cls.isAnnotationPresent(Example.class)) {
                Example[] exampleArray;
                ArrayList<List<String>> examplesList = new ArrayList<List<String>>();
                if (cls.isAnnotationPresent(Examples.class)) {
                    exampleArray = cls.getDeclaredAnnotation(Examples.class).value();
                } else {
                    Example[] exampleArray2 = new Example[1];
                    exampleArray = exampleArray2;
                    exampleArray2[0] = cls.getDeclaredAnnotation(Example.class);
                }
                for (Example example : exampleArray) {
                    List<String> exampleLines = Arrays.asList(example.value());
                    examplesList.add(exampleLines);
                }
                examples = (String[][])examplesList.stream().map(List::toArray).toArray(x$0 -> new String[x$0][]);
            }
            Boolean document = !cls.isAnnotationPresent(DoNotDocument.class);
            if (ASAPropertyExpression.class.isAssignableFrom(cls)) {
                if (expressionType == null) {
                    expressionType = ExpressionType.PROPERTY;
                }
                ASAPropertyExpression asaPropertyExpression = (ASAPropertyExpression)cls.newInstance();
                if (syntaxes.length < 2) {
                    throw new RuntimeException(String.format("Property Expression %s does not have two syntaxes which denote the property and the fromType (see docs)", ((Object)((Object)this)).getClass().getCanonicalName()));
                }
                String property = syntaxes[0];
                String fromType = syntaxes[1];
                String[] propertySyntaxes = new String[]{"[" + this.getName().toLowerCase() + "] [the] " + property + " of %" + fromType + "%", "[" + this.getName().toLowerCase() + "] %" + fromType + "%'[s] " + property};
                Skript.registerExpression(asaPropertyExpression.getClass(), asaPropertyExpression.getReturnType(), (ExpressionType)expressionType, (String[])propertySyntaxes);
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.PROPERTY_EXPRESSION, elementSyntaxes, asaPropertyExpression.getClass(), document, examples));
                ++this.loadedExpressions;
            } else if (ASAExpression.class.isAssignableFrom(cls)) {
                if (expressionType == null) {
                    expressionType = ExpressionType.SIMPLE;
                }
                ASAExpression asaExpression = (ASAExpression)cls.newInstance();
                Skript.registerExpression(asaExpression.getClass(), asaExpression.getReturnType(), (ExpressionType)expressionType, (String[])syntaxes);
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.EXPRESSION, elementSyntaxes, asaExpression.getClass(), document, examples));
                ++this.loadedExpressions;
            } else if (ASAType.class.isAssignableFrom(cls)) {
                ASAType asaType = (ASAType)cls.newInstance();
                Classes.registerClass(asaType.getClassInfo());
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.TYPE, elementSyntaxes, asaType.getClass(), document, examples));
                ++this.loadedTypes;
            } else if (ASAEffect.class.isAssignableFrom(cls)) {
                ASAEffect asaEffect = (ASAEffect)cls.newInstance();
                Skript.registerEffect(asaEffect.getClass(), (String[])syntaxes);
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.EFFECT, elementSyntaxes, asaEffect.getClass(), document, examples));
                ++this.loadedEffects;
            } else if (ASACondition.class.isAssignableFrom(cls)) {
                ASACondition asaCondition = (ASACondition)cls.newInstance();
                Skript.registerCondition(asaCondition.getClass(), (String[])syntaxes);
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.CONDITION, elementSyntaxes, asaCondition.getClass(), document, examples));
                ++this.loadedConditions;
            } else if (ASAEvent.class.isAssignableFrom(cls)) {
                ASAEvent asaEvent = (ASAEvent)cls.newInstance();
                Skript.registerEvent((String)asaEvent.getName(), asaEvent.getSkriptEvent(), asaEvent.getEventClass(), (String[])syntaxes);
                if (asaEvent.getEventValues() != null) {
                    EventValue<T, ?>[] eventValues;
                    for (EventValue eventValue : eventValues = asaEvent.getEventValues()) {
                        EventValues.registerEventValue(asaEvent.getEventClass(), eventValue.getValueClass(), eventValue, (int)eventValue.getEventTime().getTime());
                    }
                }
                this.asaElements.add(new ASAElement(name, description, ASAElement.ElementType.EVENT, elementSyntaxes, asaEvent.getClass(), document, examples));
                ++this.loadedEvents;
            } else if (ASAConverter.class.isAssignableFrom(cls)) {
                ASAConverter asaConverter = (ASAConverter)cls.newInstance();
                Converters.registerConverter(asaConverter.getFromClass(), asaConverter.getToClass(), (Converter)asaConverter);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.getLogger().warning("Current Class: " + cls.getCanonicalName());
            e.printStackTrace();
        }
    }

    public void registerClasses(String pckg) {
        ArrayList classes = new ArrayList(ClassFinder.getClasses(this.getFile(), pckg));
        classes.sort(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return this.getWeight(o1).compareTo(this.getWeight(o2));
            }

            public Integer getWeight(Class<?> cls) {
                if (ASAType.class.isAssignableFrom(cls)) {
                    return 1;
                }
                return 2;
            }
        });
        for (Class clazz : classes) {
            this.registerClass(clazz);
        }
    }

    public void generateDocumentation() {
        File javaPluginFolder = this.getDataFolder();
        if (!javaPluginFolder.exists()) {
            javaPluginFolder.mkdir();
        }
        File docsFile = new File(javaPluginFolder, "docs.json");
        JSONObject jsonObject = new JSONObject();
        JSONArray eventsArray = new JSONArray();
        JSONArray conditionsArray = new JSONArray();
        JSONArray effectsArray = new JSONArray();
        JSONArray expressionsArray = new JSONArray();
        JSONArray typesArray = new JSONArray();
        for (ASAElement asaElement : this.asaElements) {
            String name = asaElement.getName();
            String description = asaElement.getDescription();
            String[][] examples = asaElement.getExamples();
            Class<? extends AutoRegisteringSkriptElement> elementClass = asaElement.getElementClass();
            ASAElement.ElementType elementType = asaElement.getElementType();
            ElementSyntax[] elementSyntaxes = asaElement.getElementSyntaxes();
            JSONObject elementJSONObject = new JSONObject();
            elementJSONObject.put((Object)"name", (Object)name);
            elementJSONObject.put((Object)"description", (Object)description);
            elementJSONObject.put((Object)"class", (Object)elementClass.getCanonicalName());
            JSONArray examplesJSONArray = new JSONArray();
            for (String[] exampleLines : examples) {
                JSONArray exampleLinesJSONArray = new JSONArray();
                exampleLinesJSONArray.addAll(Arrays.asList(exampleLines));
                examplesJSONArray.add((Object)exampleLinesJSONArray);
            }
            elementJSONObject.put((Object)"examples", (Object)examplesJSONArray);
            JSONArray syntaxesJSONArray = new JSONArray();
            switch (elementType) {
                case CONDITION: 
                case EFFECT: 
                case EVENT: 
                case EXPRESSION: {
                    for (ElementSyntax elementSyntax : elementSyntaxes) {
                        for (String rawSyntax : elementSyntax.getRawSyntaxes()) {
                            String[] syntaxJSONObject = new JSONObject();
                            syntaxJSONObject.put((Object)"syntax", (Object)rawSyntax);
                            if (elementSyntax.isUsingBinds().booleanValue()) {
                                JSONArray bindsArray = new JSONArray();
                                bindsArray.addAll(Arrays.asList(elementSyntax.getBinds()));
                                syntaxJSONObject.put((Object)"binds", (Object)bindsArray);
                            }
                            syntaxesJSONArray.add((Object)syntaxJSONObject);
                        }
                    }
                    elementJSONObject.put((Object)"syntaxes", (Object)syntaxesJSONArray);
                    break;
                }
                case PROPERTY_EXPRESSION: {
                    for (ElementSyntax elementSyntax : elementSyntaxes) {
                        String[] syntaxes;
                        String[] rawSyntaxes = elementSyntax.getRawSyntaxes();
                        String property = rawSyntaxes[0];
                        String fromType = rawSyntaxes[1];
                        for (String syntax : syntaxes = new String[]{"[the] " + property + " of %" + fromType + "%", "%" + fromType + "%'[s] " + property}) {
                            JSONObject syntaxJSONObject = new JSONObject();
                            syntaxJSONObject.put((Object)"syntax", (Object)syntax);
                            if (elementSyntax.isUsingBinds().booleanValue()) {
                                JSONArray bindsArray = new JSONArray();
                                bindsArray.addAll(Arrays.asList(elementSyntax.getBinds()));
                                syntaxJSONObject.put((Object)"binds", (Object)bindsArray);
                            }
                            syntaxesJSONArray.add((Object)syntaxJSONObject);
                        }
                    }
                    break;
                }
                case TYPE: {
                    for (ElementSyntax elementSyntax : elementSyntaxes) {
                        JSONObject syntaxJSONObject = new JSONObject();
                        syntaxJSONObject.put((Object)"syntax", (Object)elementSyntax.getRawSyntaxes());
                        syntaxesJSONArray.add((Object)syntaxJSONObject);
                    }
                    break;
                }
            }
            AutoRegisteringSkriptElement autoRegisteringSkriptElement = null;
            try {
                autoRegisteringSkriptElement = elementClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            switch (elementType) {
                case EVENT: {
                    ASAEvent asaEvent = (ASAEvent)autoRegisteringSkriptElement;
                    elementJSONObject.put((Object)"eventClass", (Object)asaEvent.getEventClass().getCanonicalName());
                    elementJSONObject.put((Object)"cancellable", (Object)Cancellable.class.isAssignableFrom(asaEvent.getEventClass()));
                    EventValue<T, ?>[] eventValues = asaEvent.getEventValues();
                    JSONArray eventValuesJSONArray = new JSONArray();
                    ArrayList<String> alreadyRegisteredClasses = new ArrayList<String>();
                    for (EventValue eventValue : eventValues) {
                        JSONObject eventValueJSONObject = new JSONObject();
                        String canonicalName = eventValue.getValueClass().getCanonicalName();
                        if (alreadyRegisteredClasses.contains(canonicalName)) continue;
                        alreadyRegisteredClasses.add(canonicalName);
                        eventValueJSONObject.put((Object)"typeClass", (Object)canonicalName);
                        ClassInfo classInfo = Classes.getExactClassInfo(eventValue.getValueClass());
                        if (classInfo != null) {
                            eventValueJSONObject.put((Object)"type", (Object)classInfo.getCodeName());
                        }
                        eventValuesJSONArray.add((Object)eventValueJSONObject);
                    }
                    elementJSONObject.put((Object)"eventValues", (Object)eventValuesJSONArray);
                    break;
                }
                case TYPE: {
                    ASAType asaType = (ASAType)autoRegisteringSkriptElement;
                    ClassInfo classInfo = asaType.getClassInfo();
                    elementJSONObject.put((Object)"typeClass", (Object)classInfo.getC().getCanonicalName());
                    elementJSONObject.put((Object)"codename", (Object)classInfo.getCodeName());
                    JSONArray patternsArray = new JSONArray();
                    patternsArray.addAll(Arrays.asList(Arrays.stream(classInfo.getUserInputPatterns()).map(Pattern::pattern).toArray(String[]::new)));
                    elementJSONObject.put((Object)"patterns", (Object)patternsArray);
                    elementJSONObject.put((Object)"type", (Object)classInfo.getCodeName());
                    break;
                }
                case EXPRESSION: {
                    ASAExpression asaExpression = (ASAExpression)autoRegisteringSkriptElement;
                    elementJSONObject.put((Object)"returnTypeClass", (Object)asaExpression.getReturnType().getCanonicalName());
                    ClassInfo returnTypeClassInfo = Classes.getExactClassInfo(asaExpression.getReturnType());
                    if (returnTypeClassInfo == null) break;
                    elementJSONObject.put((Object)"returnType", (Object)returnTypeClassInfo.getCodeName());
                }
            }
            switch (elementType) {
                case CONDITION: {
                    conditionsArray.add((Object)elementJSONObject);
                    break;
                }
                case EFFECT: {
                    effectsArray.add((Object)elementJSONObject);
                    break;
                }
                case EVENT: {
                    eventsArray.add((Object)elementJSONObject);
                    break;
                }
                case PROPERTY_EXPRESSION: {
                    expressionsArray.add((Object)elementJSONObject);
                    break;
                }
                case EXPRESSION: {
                    expressionsArray.add((Object)elementJSONObject);
                    break;
                }
                case TYPE: {
                    typesArray.add((Object)elementJSONObject);
                }
            }
        }
        jsonObject.put((Object)"events", (Object)eventsArray);
        jsonObject.put((Object)"conditions", (Object)conditionsArray);
        jsonObject.put((Object)"effects", (Object)effectsArray);
        jsonObject.put((Object)"expressions", (Object)expressionsArray);
        jsonObject.put((Object)"types", (Object)typesArray);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(docsFile), "UTF-8"));){
            out.write(jsonObject.toJSONString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CommandExecutor getCommand(AddonCommand[] addonCommands) {
        ArrayList<AddonCommand> addonCommandsList = new ArrayList<AddonCommand>(Arrays.asList(addonCommands));
        addonCommandsList.add(new AddonCommand(){

            @Override
            public String[] getSubCommands() {
                return new String[]{"documentation", "docs", "generatedocs"};
            }

            @Override
            public String usage() {
                return "(documentation|docs|generatedocs)";
            }

            @Override
            public String description() {
                return "Generate documentation files";
            }

            @Override
            public void handle(CommandSender commandSender, String alias, List<String> arguments) {
                if (commandSender.hasPermission(Addon.this.getName() + ".command.generatedocs") || commandSender.isOp()) {
                    commandSender.sendMessage(ChatColor.GREEN + "Generating documentation..");
                    Addon.this.generateDocumentation();
                    commandSender.sendMessage(ChatColor.GREEN + "Done generating documentation!");
                }
            }
        });
        addonCommandsList.add(new AddonCommand(){

            @Override
            public String[] getSubCommands() {
                return new String[]{"help", "?"};
            }

            @Override
            public String usage() {
                return "(help|?)";
            }

            @Override
            public String description() {
                return "Retrieve the help";
            }

            @Override
            public void handle(CommandSender commandSender, String alias, List<String> arguments) {
                commandSender.sendMessage("     ");
                if (commandSender.hasPermission(Addon.this.getName() + ".command.help") || commandSender.isOp()) {
                    commandSender.sendMessage(ChatColor.GREEN + Addon.this.getName() + " Help");
                    for (AddonCommand addonCommand : Addon.this.getAddonCommands()) {
                        commandSender.sendMessage(ChatColor.GREEN + "/" + alias + " " + addonCommand.usage() + " ");
                        commandSender.sendMessage(ChatColor.YELLOW + addonCommand.description());
                    }
                }
            }
        });
        this.addonCommands.addAll(addonCommandsList);
        return (commandSender, command, s, arguments) -> {
            if (arguments.length > 0) {
                String subcommand = arguments[0];
                ArrayList<String> argumentsList = new ArrayList<String>(Arrays.asList(arguments));
                argumentsList.remove(0);
                for (AddonCommand addonCommand : addonCommandsList) {
                    for (String addonSubCommand : addonCommand.getSubCommands()) {
                        if (!addonSubCommand.equals(subcommand)) continue;
                        addonCommand.handle(commandSender, s, argumentsList);
                        return true;
                    }
                }
            } else {
                commandSender.sendMessage(ChatColor.YELLOW + this.getName() + ChatColor.GREEN + " - An addon by " + ChatColor.YELLOW + String.join((CharSequence)", ", this.getDescription().getAuthors()));
                commandSender.sendMessage(ChatColor.GREEN + "Using Addon Core from Andrew's Skript Addons");
                commandSender.sendMessage(ChatColor.GREEN + "Version: " + ChatColor.YELLOW + this.getDescription().getVersion());
            }
            return true;
        };
    }

    public int getLoadedExpressions() {
        return this.loadedExpressions;
    }

    public int getLoadedTypes() {
        return this.loadedTypes;
    }

    public int getLoadedEffects() {
        return this.loadedEffects;
    }

    public int getLoadedConditions() {
        return this.loadedConditions;
    }

    public int getLoadedEvents() {
        return this.loadedEvents;
    }

    public void assertNotNull(Object object, String message) throws NullExpressionException {
        if (object == null) {
            throw new NullExpressionException(message);
        }
    }

    public static interface AddonCommand {
        public String[] getSubCommands();

        public String usage();

        public String description();

        public void handle(CommandSender var1, String var2, List<String> var3);
    }
}

