/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.addoncore;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import me.andrew28.addons.conquer.addoncore.ASAType;
import me.andrew28.addons.conquer.addoncore.annotations.DoNotRegister;

@DoNotRegister
public abstract class ASAEnumType<T extends Enum<T>>
extends ASAType<T> {
    private Class<T> enumClass;
    private Map<T, String> mappings = new HashMap<T, String>();
    private Map<String, T> reverseMappings = new HashMap<String, T>();

    public Map<T, String> getMappings() {
        return this.mappings;
    }

    public Map<String, T> getReverseMappings() {
        return this.reverseMappings;
    }

    public Class<T> getEnumClass() {
        if (this.enumClass == null) {
            this.enumClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        return this.enumClass;
    }

    public abstract String getCodeName();

    public String getFriendlyName() {
        return this.getCodeName();
    }

    public String toString(T t) {
        return this.toString(t, 0);
    }

    public String toString(T t, int flags) {
        if (this.mappings.containsKey(t)) {
            String name = this.mappings.get(t);
            if ((flags & 1) != 0) {
                name = name + "s";
            }
            return name;
        }
        return null;
    }

    public void setupMappings() {
        for (Enum t : (Enum[])this.getEnumClass().getEnumConstants()) {
            String text = t.name().replace('_', ' ').toLowerCase();
            this.addMapping(text, t);
        }
    }

    public void addMapping(String from, T to) {
        this.mappings.put(to, from);
        this.reverseMappings.put(from, to);
    }

    public T fromString(String s) {
        if (s.endsWith("s") && this.reverseMappings.containsKey(s.substring(0, s.length() - 1).toLowerCase())) {
            return (T)((Enum)this.reverseMappings.get(s.substring(0, s.length() - 1).toLowerCase()));
        }
        return (T)((Enum)this.reverseMappings.get(s.toLowerCase()));
    }

    public String getUserPattern() {
        return null;
    }

    public T getDefaultValue() {
        return null;
    }

    public EventValueExpression<T> getDefaultEventValueExpression() {
        return null;
    }

    public String toVariableNameString(T t) {
        return this.getCodeName() + ":" + this.toString(t);
    }

    public String getVariableNamePattern() {
        return this.getCodeName() + ":.+";
    }

    @Override
    public ClassInfo<T> getClassInfo() {
        final ASAEnumType asaEnumType = this;
        this.setupMappings();
        ClassInfo classInfo = new ClassInfo(this.getEnumClass(), this.getCodeName()).name(this.getFriendlyName()).user(new String[]{this.getUserPattern() != null ? this.getUserPattern() : "(asa)?(-)?(enum)?" + this.getCodeName()}).parser(new Parser<T>(){

            public String toString(T t, int flags) {
                return asaEnumType.toString(t, flags);
            }

            public T parse(String s, ParseContext context) {
                return asaEnumType.fromString(s);
            }

            public String toVariableNameString(T t) {
                return asaEnumType.toVariableNameString(t);
            }

            public String getVariableNamePattern() {
                return asaEnumType.getVariableNamePattern();
            }
        }).serializer(new Serializer<T>(){

            public Fields serialize(T t) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("enum", (Object)((Enum)t).name());
                return fields;
            }

            public void deserialize(T t, Fields fields) throws StreamCorruptedException, NotSerializableException {
                assert (false);
            }

            protected T deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                String name = (String)fields.getObject("enum");
                for (Enum t : (Enum[])asaEnumType.getEnumClass().getEnumConstants()) {
                    if (!t.name().equals(name)) continue;
                    return t;
                }
                return null;
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return true;
            }
        });
        if (this.getDefaultValue() != null) {
            classInfo.defaultExpression((DefaultExpression)new SimpleLiteral(this.getDefaultValue(), true));
        } else if (this.getDefaultEventValueExpression() != null) {
            classInfo.defaultExpression(this.getDefaultEventValueExpression());
        }
        return classInfo;
    }
}

