/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer;

import com.massivecraft.factions.Rel;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.event.EventFactionsChunksChange;
import com.massivecraft.factions.event.EventFactionsCreate;
import com.massivecraft.factions.event.EventFactionsDisband;
import com.massivecraft.factions.event.EventFactionsMembershipChange;
import com.massivecraft.factions.event.EventFactionsNameChange;
import com.massivecraft.factions.event.EventFactionsRelationChange;
import com.massivecraft.massivecore.ps.PS;
import me.andrew28.addons.conquer.FactionsImpl;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.EventWrapperListener;
import me.andrew28.addons.conquer.api.events.ConquerFactionCreateEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionDisbandEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionLandClaimEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionLandUnclaimEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionPlayerJoinEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionPlayerLeaveEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationChangeEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRenameEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;

public class FactionsImplEventWrapper
extends EventWrapperListener {
    private FactionsImpl factions;

    public FactionsImplEventWrapper(FactionsImpl factions) {
        this.factions = factions;
    }

    public FactionsImpl getFactions() {
        return this.factions;
    }

    @EventHandler
    public void onFactionCreate(EventFactionsCreate eventFactionsCreate) {
        ConquerFactionCreateEvent e = new ConquerFactionCreateEvent(eventFactionsCreate.getMPlayer().getPlayer(), eventFactionsCreate.getFactionId());
        this.throwEvent(e);
        if (((Cancellable)e).isCancelled()) {
            eventFactionsCreate.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionDisband(EventFactionsDisband eventFactionsDisband) {
        ConquerFactionDisbandEvent e = new ConquerFactionDisbandEvent(this.factions.getFactionsFactionFromFaction(eventFactionsDisband.getFaction()), eventFactionsDisband.getMPlayer().getPlayer());
        this.throwEvent(e);
        if (((Cancellable)e).isCancelled()) {
            eventFactionsDisband.setCancelled(true);
        }
    }

    @EventHandler
    public void onLandChangeEvent(EventFactionsChunksChange eventFactionsChunksChange) {
        eventFactionsChunksChange.getTypeChunks().forEach((type, psList) -> {
            FactionsImpl.FactionsFaction faction = this.factions.getFactionsFactionFromFaction(eventFactionsChunksChange.getNewFaction());
            Player player = eventFactionsChunksChange.getMPlayer().getPlayer();
            switch (type) {
                case BUY: 
                case CONQUER: 
                case PILLAGE: {
                    psList.forEach(ps -> {
                        FactionsImpl.FactionsClaim claim = this.factions.getFactionsClaimFromPS((PS)ps);
                        ConquerFactionLandClaimEvent e = new ConquerFactionLandClaimEvent(faction, player, claim);
                        this.throwEvent(e);
                        if (((Cancellable)e).isCancelled()) {
                            eventFactionsChunksChange.setCancelled(true);
                        }
                    });
                    break;
                }
                case SELL: {
                    psList.forEach(ps -> {
                        FactionsImpl.FactionsClaim claim = this.factions.getFactionsClaimFromPS((PS)ps);
                        ConquerFactionLandUnclaimEvent e = new ConquerFactionLandUnclaimEvent(faction, player, claim);
                        this.throwEvent(e);
                        if (((Cancellable)e).isCancelled()) {
                            eventFactionsChunksChange.setCancelled(true);
                        }
                    });
                }
            }
        });
    }

    @EventHandler
    public void onFactionPlayerJoin(EventFactionsMembershipChange eventFactionsMembershipChange) {
        FactionsImpl.FactionsFaction faction = this.factions.getFactionsFactionFromFaction(eventFactionsMembershipChange.getNewFaction());
        Player player = eventFactionsMembershipChange.getMPlayer().getPlayer();
        Boolean join = false;
        Boolean cancelChecks = eventFactionsMembershipChange.getReason().isCancellable();
        switch (eventFactionsMembershipChange.getReason()) {
            case CREATE: 
            case RANK: 
            case JOIN: {
                join = true;
                break;
            }
        }
        Event e = null;
        if (join.booleanValue()) {
            ConquerFactionPlayerJoinEvent.JoinReason joinReason = ConquerFactionPlayerJoinEvent.JoinReason.OTHER;
            switch (eventFactionsMembershipChange.getReason()) {
                case JOIN: {
                    joinReason = ConquerFactionPlayerJoinEvent.JoinReason.COMMAND;
                    break;
                }
                case CREATE: {
                    joinReason = ConquerFactionPlayerJoinEvent.JoinReason.CREATE;
                }
            }
            e = new ConquerFactionPlayerJoinEvent(faction, player, joinReason);
        } else {
            ConquerFactionPlayerLeaveEvent.LeaveReason leaveReason = ConquerFactionPlayerLeaveEvent.LeaveReason.OTHER;
            switch (eventFactionsMembershipChange.getReason()) {
                case LEAVE: {
                    leaveReason = ConquerFactionPlayerLeaveEvent.LeaveReason.LEAVE;
                    break;
                }
                case KICK: {
                    leaveReason = ConquerFactionPlayerLeaveEvent.LeaveReason.KICKED;
                    break;
                }
                case DISBAND: {
                    leaveReason = ConquerFactionPlayerLeaveEvent.LeaveReason.DISBAND;
                }
            }
            e = new ConquerFactionPlayerLeaveEvent(faction, player, leaveReason);
        }
        this.throwEvent(e);
        if (cancelChecks.booleanValue() && ((Cancellable)e).isCancelled()) {
            eventFactionsMembershipChange.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionRename(EventFactionsNameChange eventFactionsNameChange) {
        FactionsImpl.FactionsFaction faction = this.factions.getFactionsFactionFromFaction(eventFactionsNameChange.getFaction());
        Player player = eventFactionsNameChange.getMPlayer().getPlayer();
        String newName = eventFactionsNameChange.getNewName();
        String oldName = ((ConquerFaction)faction).getName();
        ConquerFactionRenameEvent e = new ConquerFactionRenameEvent(faction, player, oldName, newName);
        this.throwEvent(e);
        if (((Cancellable)e).isCancelled()) {
            eventFactionsNameChange.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionRelationChange(EventFactionsRelationChange eventFactionsRelationChange) {
        ConquerFactionRelationChangeEvent.Relation newRelation;
        ConquerFactionRelationChangeEvent.Relation oldRelation;
        FactionsImpl.FactionsFaction target;
        FactionsImpl.FactionsFaction sender = this.factions.getFactionsFactionFromFaction(eventFactionsRelationChange.getFaction());
        ConquerFactionRelationChangeEvent e = new ConquerFactionRelationChangeEvent(sender, target = this.factions.getFactionsFactionFromFaction(eventFactionsRelationChange.getOtherFaction()), oldRelation = this.getRelation(eventFactionsRelationChange.getFaction().getRelationTo((RelationParticipator)eventFactionsRelationChange.getOtherFaction())), newRelation = this.getRelation(eventFactionsRelationChange.getNewRelation()));
        if (((Cancellable)e).isCancelled()) {
            eventFactionsRelationChange.setCancelled(true);
        }
    }

    public ConquerFactionRelationChangeEvent.Relation getRelation(Rel rel) {
        switch (rel) {
            case ENEMY: {
                return ConquerFactionRelationChangeEvent.Relation.ENEMY;
            }
            case NEUTRAL: {
                return ConquerFactionRelationChangeEvent.Relation.NEUTRAL;
            }
            case TRUCE: {
                return ConquerFactionRelationChangeEvent.Relation.TRUCE;
            }
            case ALLY: {
                return ConquerFactionRelationChangeEvent.Relation.ALLY;
            }
        }
        return ConquerFactionRelationChangeEvent.Relation.OTHER;
    }
}

