/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer;

import ch.njol.skript.Skript;
import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Rel;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.factions.entity.MPlayerColl;
import com.massivecraft.massivecore.ps.PS;
import java.io.StreamCorruptedException;
import java.util.Date;
import java.util.UUID;
import me.andrew28.addons.conquer.FactionsImplEventWrapper;
import me.andrew28.addons.conquer.addoncore.Addon;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.Role;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationChangeEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class FactionsImpl
implements FactionsPlugin {
    private FactionColl factionColl;
    private BoardColl boardColl;
    private MPlayerColl mPlayerColl;

    @Override
    public boolean canBeUsed() {
        return Bukkit.getPluginManager().getPlugin("Factions") != null && Bukkit.getPluginManager().getPlugin("Factions").isEnabled() && Bukkit.getPluginManager().getPlugin("Factions").getDescription().getAuthors().contains("Cayorion") && Bukkit.getPluginManager().getPlugin("MassiveCore") != null && Bukkit.getPluginManager().getPlugin("MassiveCore").isEnabled();
    }

    @Override
    public void initialize() {
        this.factionColl = FactionColl.get();
        this.boardColl = BoardColl.get();
        this.mPlayerColl = MPlayerColl.get();
    }

    @Override
    public void initializeSkriptComponents(Addon addon) {
    }

    @Override
    public Listener getEventWrapperListener() {
        return new FactionsImplEventWrapper(this);
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.factionColl != null && this.boardColl != null && this.mPlayerColl != null;
    }

    @Override
    public ConquerFaction[] getAll() {
        return (ConquerFaction[])this.factionColl.getAll().stream().map(this::getFactionsFactionFromFaction).toArray(ConquerFaction[]::new);
    }

    @Override
    public ConquerFaction getAtLocation(Location location) {
        return this.getFactionsFactionFromFaction(this.boardColl.getFactionAt(this.getPSFromLocation(location)));
    }

    @Override
    public ConquerFaction getByName(String name) {
        return this.getFactionsFactionFromFaction(this.factionColl.getByName(name));
    }

    @Override
    public ConquerFaction getFaction(Claim claim) {
        Chunk chunk = (Chunk)claim.getRepresentationObject();
        return this.getFactionsFactionFromFaction(this.boardColl.getFactionAt(this.getPSFromChunk(chunk)));
    }

    @Override
    public ConquerPlayer getConquerPlayer(Player player) {
        return this.getFactionsPlayerFromPlayer(player);
    }

    @Override
    public Claim getClaim(Location location) {
        return this.getFactionsClaimFromChunk(location.getChunk());
    }

    @Override
    public Claim[] getClaims(ConquerFaction faction) {
        Faction massiveFaction = this.getFactionFromFactionsFaction((FactionsFaction)faction);
        return (Claim[])this.boardColl.getChunks(massiveFaction).stream().map(ps -> this.getFactionsClaimFromChunk(this.getChunkFromPS((PS)ps))).toArray(Claim[]::new);
    }

    @Override
    public void claim(ConquerFaction faction, Location location) {
        this.boardColl.setFactionAt(this.getPSFromLocation(location), this.getFactionFromFactionsFaction((FactionsFaction)faction));
    }

    @Override
    public void removeClaim(Location location) {
        this.boardColl.removeAt(this.getPSFromLocation(location));
    }

    @Override
    public Claim deserializeClaim(Fields f) throws StreamCorruptedException {
        World w = Bukkit.getWorld((String)((String)f.getObject("world")));
        Integer x = (Integer)f.getObject("X");
        Integer z = (Integer)f.getObject("Z");
        return this.getFactionsClaimFromChunk(w.getChunkAt(x.intValue(), z.intValue()));
    }

    @Override
    public ConquerFaction deserializeFaction(Fields f) throws StreamCorruptedException {
        return this.getFactionsFactionFromFaction(this.factionColl.get(f.getObject("id")));
    }

    public PS getPSFromLocation(Location location) {
        return PS.valueOf((Location)location);
    }

    public Location getLocationFromPS(PS ps) {
        if (ps == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)ps.getWorld()), ps.getLocationX().doubleValue(), ps.getLocationY().doubleValue(), ps.getLocationZ().doubleValue(), ps.getYaw().floatValue(), ps.getPitch().floatValue());
    }

    public Chunk getChunkFromPS(PS ps) {
        return Bukkit.getWorld((String)ps.getWorld()).getChunkAt(ps.getChunkX().intValue(), ps.getChunkZ().intValue());
    }

    public PS getPSFromChunk(Chunk chunk) {
        return PS.valueOf((Chunk)chunk);
    }

    public FactionsClaim getFactionsClaimFromPS(PS ps) {
        return this.getFactionsClaimFromChunk(this.getChunkFromPS(ps));
    }

    public FactionsClaim getFactionsClaimFromChunk(Chunk chunk) {
        return new FactionsClaim(this, chunk);
    }

    public OfflinePlayer getOfflinePlayerFromMPlayer(MPlayer mPlayer) {
        return Bukkit.getOfflinePlayer((UUID)mPlayer.getUuid());
    }

    public MPlayer getMPlayerFromOfflinePlayer(OfflinePlayer offlinePlayer) {
        return (MPlayer)this.mPlayerColl.get((Object)offlinePlayer.getUniqueId());
    }

    public FactionsPlayer getFactionsPlayerFromPlayer(Player player) {
        return new FactionsPlayer(player, this, (MPlayer)MPlayerColl.get().get((Object)player.getUniqueId()));
    }

    public FactionsFaction getFactionsFactionFromFaction(Faction faction) {
        if (!faction.isNormal()) {
            return null;
        }
        return new FactionsFaction(this, faction);
    }

    public Faction getFactionFromFactionsFaction(FactionsFaction factionsFaction) {
        return factionsFaction.getFaction();
    }

    public static class FactionsPlayer
    extends ConquerPlayer {
        private FactionsImpl factions;
        private MPlayer mPlayer;

        public FactionsPlayer(Player player, FactionsImpl factions, MPlayer mPlayer) {
            super(player);
            this.factions = factions;
            this.mPlayer = mPlayer;
        }

        @Override
        public double getPower() {
            return this.mPlayer.getPower();
        }

        @Override
        public double getMaximumPower() {
            return this.mPlayer.getPowerMax();
        }

        @Override
        public double getPowerBoost() {
            return this.mPlayer.getPowerMin();
        }

        @Override
        public void setPower(double power) {
            this.mPlayer.setPower(Double.valueOf(power));
        }

        @Override
        public void resetPower() {
            this.mPlayer.setPower(Double.valueOf(0.0));
        }

        @Override
        public void setPowerBoost(double powerBoost) {
            this.mPlayer.setPowerBoost(Double.valueOf(powerBoost));
        }

        @Override
        public void resetPowerBoost() {
            this.mPlayer.setPowerBoost(Double.valueOf(0.0));
        }

        @Override
        public boolean hasFaction() {
            return !this.mPlayer.getFaction().isNone();
        }

        @Override
        public ConquerFaction getFaction() {
            return this.factions.getFactionsFactionFromFaction(this.mPlayer.getFaction());
        }

        @Override
        public void setFaction(ConquerFaction faction) {
            this.mPlayer.setFaction(((FactionsFaction)faction).getFaction());
        }

        @Override
        public void resetFaction() {
            this.mPlayer.resetFactionData();
        }

        @Override
        public boolean isAutoClaiming() {
            return this.mPlayer.getAutoClaimFaction() != null;
        }

        @Override
        public void setAutoClaiming(Boolean autoClaiming) {
            this.mPlayer.setAutoClaimFaction(autoClaiming != false ? this.mPlayer.getFaction() : null);
        }

        @Override
        public Date getLastActivity() {
            return new Date(this.mPlayer.getLastActivityMillis());
        }

        @Override
        public void setLastActivity(Date date) {
            this.mPlayer.setLastActivityMillis(date.getTime());
        }

        @Override
        public Role getRole() {
            switch (this.mPlayer.getRole()) {
                case RECRUIT: {
                    return Role.OTHER;
                }
                case MEMBER: {
                    return Role.NORMAL;
                }
                case OFFICER: {
                    return Role.MODERATOR;
                }
                case LEADER: {
                    return Role.ADMIN;
                }
            }
            return Role.OTHER;
        }

        @Override
        public void setRole(Role role) {
            switch (role) {
                case NORMAL: {
                    this.mPlayer.setRole(Rel.MEMBER);
                }
                case ADMIN: {
                    this.mPlayer.setRole(Rel.LEADER);
                }
                case MODERATOR: {
                    this.mPlayer.setRole(Rel.OFFICER);
                }
                case OTHER: {
                    this.mPlayer.setRole(Rel.RECRUIT);
                }
            }
        }

        @Override
        public String getTitle() {
            return this.mPlayer.getTitle();
        }

        @Override
        public void setTitle(String title) {
            this.mPlayer.setTitle(title);
        }

        @Override
        public void resetTitle() {
            this.mPlayer.setTitle("");
        }

        @Override
        public double getMinimumPower() {
            return this.mPlayer.getPowerMin();
        }

        @Override
        public boolean getAutomaticMapUpdateMode() {
            return this.mPlayer.isMapAutoUpdating();
        }

        @Override
        public void setAutomaticMapUpdateMode(Boolean automaticMapUpdateMode) {
            this.mPlayer.setMapAutoUpdating(automaticMapUpdateMode);
        }
    }

    public static class FactionsFaction
    extends ConquerFaction {
        private FactionsImpl factions;
        private Faction faction;

        public FactionsFaction(FactionsImpl factions, Faction faction) {
            this.factions = factions;
            this.faction = faction;
        }

        public FactionsImpl getFactions() {
            return this.factions;
        }

        public void setFactions(FactionsImpl factions) {
            this.factions = factions;
        }

        public Faction getFaction() {
            return this.faction;
        }

        public void setFaction(Faction faction) {
            this.faction = faction;
        }

        @Override
        public double getPower() {
            return this.faction.getPower();
        }

        @Override
        public double getMaximumPower() {
            return this.faction.getPowerMax();
        }

        @Override
        public double getPowerBoost() {
            return this.faction.getPowerBoost();
        }

        @Override
        public String getName() {
            return this.faction.getName();
        }

        @Override
        public void setName(String name) {
            this.faction.setName(name);
        }

        @Override
        public Fields serialize() {
            Fields f = new Fields();
            f.putObject("id", (Object)this.faction.getId());
            return f;
        }

        @Override
        public ConquerFaction.FactionCommandSender getFactionCommandSender() {
            return new ConquerFaction.FactionCommandSender(){

                public void sendMessage(String s) {
                    faction.sendMessage((Object)s);
                }

                @Override
                public void sendMessage(String[] messages) {
                    faction.sendMessage((Object[])messages);
                }
            };
        }

        @Override
        public String getDescription() {
            return this.faction.getDescription();
        }

        @Override
        public void setDescription(String description) {
            this.faction.setDescription(description);
        }

        @Override
        public String getMotd() {
            return this.faction.getMotd();
        }

        @Override
        public void setMotd(String motd) {
            this.faction.setMotd(motd);
        }

        @Override
        public String getIdentifier() {
            return this.faction.getId();
        }

        @Override
        public void setIdentifier(String identifier) {
            Skript.error((String)"Factions Original Implementation does not support setting the identifier of factions, no action was done");
        }

        @Override
        public Date getCreationDate() {
            return new Date(this.faction.getCreatedAtMillis());
        }

        @Override
        public void setCreationDate(Date date) {
            this.faction.setCreatedAtMillis(date.getTime());
        }

        @Override
        public void setPowerBoost(Double powerBoost) {
            this.faction.setPowerBoost(powerBoost);
        }

        @Override
        public OfflinePlayer getLeader() {
            return this.factions.getOfflinePlayerFromMPlayer(this.faction.getLeader());
        }

        @Override
        public void setLeader(OfflinePlayer leader) {
            this.factions.getMPlayerFromOfflinePlayer(leader).setRole(Rel.LEADER);
        }

        @Override
        public Location getHome() {
            return this.factions.getLocationFromPS(this.faction.getHome());
        }

        @Override
        public void setHome(Location location) {
            this.faction.setHome(this.factions.getPSFromLocation(location));
        }

        @Override
        public OfflinePlayer[] getPlayers() {
            return (OfflinePlayer[])this.faction.getMPlayers().stream().map(mPlayer -> this.factions.getOfflinePlayerFromMPlayer((MPlayer)mPlayer)).toArray(OfflinePlayer[]::new);
        }

        @Override
        public void addPlayer(OfflinePlayer offlinePlayer) {
            this.faction.getMPlayers().add(this.factions.getMPlayerFromOfflinePlayer(offlinePlayer));
        }

        @Override
        public void removePlayer(OfflinePlayer offlinePlayer) {
            this.faction.getMPlayers().remove(this.factions.getMPlayerFromOfflinePlayer(offlinePlayer));
        }

        @Override
        public ConquerFactionRelationChangeEvent.Relation getRelationShipTo(ConquerFaction otherFaction) {
            Faction massiveFaction = this.faction;
            Faction massiveFactionTarget = ((FactionsFaction)otherFaction).faction;
            ConquerFactionRelationChangeEvent.Relation relation = ConquerFactionRelationChangeEvent.Relation.OTHER;
            switch (massiveFaction.getRelationTo((RelationParticipator)massiveFactionTarget)) {
                case ENEMY: {
                    relation = ConquerFactionRelationChangeEvent.Relation.ENEMY;
                    break;
                }
                case NEUTRAL: {
                    relation = ConquerFactionRelationChangeEvent.Relation.NEUTRAL;
                    break;
                }
                case TRUCE: {
                    relation = ConquerFactionRelationChangeEvent.Relation.TRUCE;
                    break;
                }
                case ALLY: {
                    relation = ConquerFactionRelationChangeEvent.Relation.ALLY;
                }
            }
            return relation;
        }
    }

    public static class FactionsClaim
    extends Claim<Chunk> {
        private FactionsImpl factions;
        private Chunk chunk;
        private PS ps;

        FactionsClaim(FactionsImpl factions, Chunk chunk) {
            this.factions = factions;
            this.chunk = chunk;
            this.ps = factions.getPSFromChunk(chunk);
        }

        public FactionsImpl getFactions() {
            return this.factions;
        }

        public Chunk getChunk() {
            return this.chunk;
        }

        @Override
        public Chunk getRepresentationObject() {
            return this.chunk;
        }

        @Override
        public String representationObjectToString(Chunk representationObject, int flags) {
            return String.format("Conquer Claim%s: Chunk[x: %d, z: %d, world %s]", (flags & 1) != 0 ? "s" : "", representationObject.getX(), representationObject.getZ(), representationObject.getWorld().getName());
        }

        @Override
        public Fields serialize() {
            Fields f = new Fields();
            f.putObject("world", (Object)this.chunk.getWorld().getName());
            f.putPrimitive("X", (Object)this.chunk.getX());
            f.putPrimitive("Z", (Object)this.chunk.getZ());
            return f;
        }

        @Override
        public void setFaction(ConquerFaction faction) {
            this.factions.boardColl.setFactionAt(this.ps, ((FactionsFaction)faction).getFaction());
        }

        @Override
        public void resetFaction() {
            this.factions.boardColl.removeAt(this.ps);
        }

        @Override
        public boolean isSafeZone() {
            return this.factions.boardColl.getFactionAt(this.ps).equals(this.factions.factionColl.getSafezone());
        }

        @Override
        public boolean isWarZone() {
            return this.factions.boardColl.getFactionAt(this.ps).equals(this.factions.factionColl.getWarzone());
        }

        public PS getPS() {
            return this.ps;
        }
    }
}

