/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer;

import java.util.Arrays;
import me.andrew28.addons.conquer.addoncore.Addon;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.FactionsPluginManager;
import me.andrew28.addons.conquer.factions.FactionsPluginType;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Conquer
extends Addon {
    private static Conquer instance;
    private FactionsPlugin factionsPlugin;
    private FactionsPluginType factionsPluginType;

    public static Conquer getInstance() {
        return instance;
    }

    @Override
    public void onAddonEnable() {
        instance = this;
        this.register("me.andrew28.addons.conquer.skript");
        this.getServer().getPluginCommand("conquer").setExecutor(this.getCommand(new Addon.AddonCommand[0]));
        if (!this.initializeImpl()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public boolean initializeImpl() {
        this.getLogger().info("Looking for Factions (or related) Plugin to hook into");
        this.getLogger().info("Possible Implementations: " + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(FactionsPluginType.values()).map(FactionsPluginType::getFriendlyName).toArray(String[]::new)));
        for (FactionsPluginType factionsPluginType : FactionsPluginType.values()) {
            FactionsPlugin factionPluginObject = null;
            if (factionsPluginType.getPluginImplementation() != null) {
                try {
                    factionPluginObject = factionsPluginType.getPluginImplementation().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.getLogger().warning("Failed to instantiate the class " + factionsPluginType.getPluginImplementation().getCanonicalName());
                    e.printStackTrace();
                }
            }
            if (factionPluginObject == null || !factionPluginObject.canBeUsed()) continue;
            this.factionsPlugin = factionPluginObject;
            this.getLogger().info("Implementation " + factionsPluginType.getFriendlyName() + " is being used!");
            this.factionsPlugin.initialize();
            this.factionsPlugin.initializeSkriptComponents(this);
            Bukkit.getPluginManager().registerEvents(this.factionsPlugin.getEventWrapperListener(), (Plugin)this);
            this.factionsPluginType = factionsPluginType;
            FactionsPluginManager.getInstance().setFactionsPlugin(this.factionsPlugin);
            return true;
        }
        this.getLogger().warning("Could not find a Factions (or related) plugins to HOOK INTO, **if you have one reply to the Addon Thread requesting for me to add support for it.**");
        return false;
    }

    public boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public FactionsPlugin getFactionsPlugin() {
        return this.factionsPlugin;
    }

    public FactionsPluginType getFactionsPluginType() {
        return this.factionsPluginType;
    }
}

