/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.spigot.skript.elements.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Objects;
import me.tonymaster21.bungeemaster.packets.spigot.SendMessageAsPlayerPacket;
import me.tonymaster21.bungeemaster.spigot.BungeeMaster;
import me.tonymaster21.bungeemaster.spigot.skript.BMEffect;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Documentation;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Example;
import org.bukkit.event.Event;

@Documentation(name="Send Message As Player", description="Force a player to say a message", examples={@Example(value={"on join:", "\tsend bungeecord message \"Hello!\" as player"})}, syntax={"make %strings/%players% (say|send) [bungee][cord] [message][s] %strings%", "(send|message) [bungee][cord] [chat] message[s] %strings% (from|as) %strings/players% [on] [bungee][cord]"})
public class EffSendMessageAsPlayer
extends BMEffect {
    private Expression<String> messages;
    private Expression<?> senders;

    protected void execute(Event event) {
        String[] messages = (String[])this.messages.getAll(event);
        Object[] senders = this.senders.getAll(event);
        if (messages == null || senders == null) {
            return;
        }
        Arrays.stream(this.getBungeeMaster().convertObjectsToNamesAndUUIDs(senders)).forEach(sender -> Arrays.stream(messages).filter(Objects::nonNull).forEach(message -> this.send(new SendMessageAsPlayerPacket((String)sender, (String)message))));
    }

    public String toString(Event event, boolean debug) {
        return "send bungeecord messages " + this.messages.toString(event, debug) + " as " + this.senders.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.senders = expressions[matchedPattern == 0 ? 0 : 1];
        this.messages = expressions[matchedPattern == 0 ? 1 : 0];
        return true;
    }

    static {
        BungeeMaster.getBungeeMaster().registerEffect(EffSendMessageAsPlayer.class);
    }
}

