/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.spigot.skript.elements.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.tonymaster21.bungeemaster.packets.spigot.BroadcastMessagePacket;
import me.tonymaster21.bungeemaster.packets.spigot.SendMessagePacket;
import me.tonymaster21.bungeemaster.spigot.BungeeMaster;
import me.tonymaster21.bungeemaster.spigot.skript.BMEffect;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Documentation;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Example;
import org.bukkit.event.Event;

@Documentation(name="Send Message", description="Send a message to players on the proxy", examples={@Example(value={"send message \"Hello!\" to \"TonyMaster21\" on bungee"})}, syntax={"broadcast [on] bungee[cord] [message][s] %strings%", "broadcast [message][s] %strings% on bungee[cord]", "(send|message) [on] bungee[cord] [message][s] %strings% to [player][s] %strings/players%", "(send|message) [message][s] %strings% to [player][s] %strings/players% on bungee[cord]"})
public class EffSendMessage
extends BMEffect {
    private Expression<?> players;
    private Expression<String> messages;
    private boolean broadcast;

    protected void execute(Event event) {
        String[] messages = (String[])this.messages.getAll(event);
        if (messages == null) {
            return;
        }
        if (this.broadcast) {
            this.send(new BroadcastMessagePacket(messages));
        } else {
            Object[] players = this.players.getAll(event);
            if (players == null) {
                return;
            }
            Arrays.stream(this.getBungeeMaster().convertObjectsToNamesAndUUIDs(players)).forEach(player -> this.send(new SendMessagePacket((String)player, messages)));
        }
    }

    public String toString(Event event, boolean debug) {
        return this.broadcast ? "broadcast " + this.messages.toString(event, debug) + " on bungeecord" : "message " + this.messages.toString(event, debug) + " to " + this.players.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.broadcast = matchedPattern == 0 || matchedPattern == 1;
        this.messages = expressions[0];
        if (!this.broadcast) {
            this.players = expressions[1];
        }
        return true;
    }

    static {
        BungeeMaster.getBungeeMaster().registerEffect(EffSendMessage.class);
    }
}

