/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.spigot.skript.elements.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.tonymaster21.bungeemaster.packets.spigot.ProxyCommandPacket;
import me.tonymaster21.bungeemaster.spigot.BungeeMaster;
import me.tonymaster21.bungeemaster.spigot.skript.BMEffect;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Documentation;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Example;
import org.bukkit.event.Event;

@Documentation(name="Run Proxy Command", description="Run a command on the proxy", examples={@Example(value={"run bungee command \"alert \"\"Hello everyone!\"\"\""})}, syntax={"(make|force) bungee[cord] [(run|execute)] [command][s] %strings%", "(run|execute) [command][s] %strings% on bungee[cord]", "(run|execute) bungee[cord] [command][s] %strings%", "(make|force) bungee[cord] [(run|execute)] [command][s] %strings% with output", "(run|execute) [command][s] %strings% on bungee[cord] with output", "(run|execute) bungee[cord] [command][s] %strings% with output"})
public class EffProxyCommand
extends BMEffect {
    private static String[] lastOutput;
    private Expression<String> commands;
    private boolean output;

    protected void execute(Event event) {
        String[] commands = (String[])this.commands.getAll(event);
        if (commands == null) {
            return;
        }
        Arrays.stream(commands).forEach(command -> {
            Object rawOutput = this.send(new ProxyCommandPacket((String)command, this.output));
            if (this.output) {
                lastOutput = (String[])Arrays.stream((Object[])rawOutput).toArray(String[]::new);
            }
        });
    }

    public String toString(Event event, boolean debug) {
        return "make bungee run command" + (this.commands.isSingle() ? "" : "s") + " " + this.commands.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.output = matchedPattern == 3 || matchedPattern == 4 || matchedPattern == 5;
        this.commands = expressions[0];
        return true;
    }

    public static String[] getLastOutput() {
        return lastOutput;
    }

    static {
        BungeeMaster.getBungeeMaster().registerEffect(EffProxyCommand.class);
    }
}

