/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.spigot.skript.elements.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.tonymaster21.bungeemaster.packets.spigot.ConnectPlayerPacket;
import me.tonymaster21.bungeemaster.spigot.BungeeMaster;
import me.tonymaster21.bungeemaster.spigot.skript.BMEffect;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Documentation;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Example;
import org.bukkit.event.Event;

@Documentation(name="Connect Player", description="Connect a player to a server", examples={@Example(value={"connect all players to \"trollmc.org\""})}, syntax={"connect %strings/players% to [local] [server] %string%", "connect %strings/players% to [remote] (ip|address) %string%"})
public class EffConnectPlayer
extends BMEffect {
    private Expression<?> players;
    private Expression<String> destination;
    private boolean remote;

    protected void execute(Event event) {
        Object[] players = this.players.getAll(event);
        String destination = (String)this.destination.getSingle(event);
        if (players == null || destination == null) {
            return;
        }
        Arrays.stream(this.getBungeeMaster().convertObjectsToNamesAndUUIDs(players)).forEach(player -> this.send(new ConnectPlayerPacket((String)player, destination, this.remote)));
    }

    public String toString(Event event, boolean debug) {
        return "connect " + this.players.toString(event, debug) + " to " + (this.remote ? "server" : "ip") + " " + this.destination.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = expressions[0];
        this.destination = expressions[1];
        this.remote = matchedPattern == 1;
        return true;
    }

    static {
        BungeeMaster.getBungeeMaster().registerEffect(EffConnectPlayer.class);
    }
}

