/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.spigot;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.tonymaster21.bungeemaster.org.bstats.bukkit.Metrics;
import me.tonymaster21.bungeemaster.packets.Packet;
import me.tonymaster21.bungeemaster.packets.PacketDirection;
import me.tonymaster21.bungeemaster.packets.PacketException;
import me.tonymaster21.bungeemaster.packets.PacketHandler;
import me.tonymaster21.bungeemaster.packets.PacketStatus;
import me.tonymaster21.bungeemaster.packets.Result;
import me.tonymaster21.bungeemaster.packets.spigot.HeartbeatPacket;
import me.tonymaster21.bungeemaster.packets.spigot.InitialPacket;
import me.tonymaster21.bungeemaster.spigot.BungeeMasterSpigotCommand;
import me.tonymaster21.bungeemaster.spigot.BungeeMasterSpigotConfig;
import me.tonymaster21.bungeemaster.spigot.skript.annotations.Documentation;
import org.apache.commons.io.IOUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BungeeMaster
extends JavaPlugin {
    private static BungeeMaster bungeeMaster;
    private UUID uuid = UUID.randomUUID();
    private File configFile = new File(this.getDataFolder(), "config.yml");
    private volatile BungeeMasterSpigotConfig bungeeMasterSpigotConfig;
    private volatile boolean heartbeatDone = true;
    private volatile long ping;
    private boolean locked = false;
    private ServerSocket serverSocket;
    private int port;
    private int minecraftPort;
    private List<PacketHandler<?>> packetHandlers = new ArrayList<PacketHandler>(Arrays.asList(new PacketHandler[0]));

    public void onEnable() {
        bungeeMaster = this;
        Plugin skriptPlugin = Bukkit.getPluginManager().getPlugin("Skript");
        if (skriptPlugin == null) {
            this.stop("You need Skript to be able to run this addon. Download Skript at https://github.com/bensku/Skript/releases");
            return;
        }
        SkriptAddon addon = Skript.registerAddon((JavaPlugin)this);
        try {
            addon.loadClasses("me.tonymaster21.bungeemaster.spigot.skript", new String[]{"elements"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> skriptPlugin.getDescription() == null ? null : skriptPlugin.getDescription().getVersion()));
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            this.getLogger().info("Failed to create data folder");
        }
        this.minecraftPort = this.getServer().getPort();
        if (!this.configFile.exists()) {
            try (FileWriter fileWriter = new FileWriter(this.configFile);){
                IOUtils.copy((InputStream)this.getResource("spigot/config.yml"), (Writer)fileWriter, (String)"UTF-8");
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to copy default configuration");
                e.printStackTrace();
            }
        }
        this.loadConfig();
        this.port = 3112;
        if (this.bungeeMasterSpigotConfig.isServerPortAuto()) {
            Throwable throwable = null;
            while (this.bungeeMasterSpigotConfig.isServerPortAuto() && this.port <= this.bungeeMasterSpigotConfig.getServerPort() + 1000) {
                try {
                    this.serverSocket = new ServerSocket(3112);
                    break;
                }
                catch (IOException e) {
                    throwable = e;
                    ++this.port;
                }
            }
            if (this.serverSocket == null) {
                this.stop("Failed to start server socket automatically");
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                return;
            }
        } else {
            this.port = this.bungeeMasterSpigotConfig.getServerPort();
            try {
                this.serverSocket = new ServerSocket(this.port);
            }
            catch (IOException e) {
                this.stop("Failed to start server socket");
                e.printStackTrace();
                return;
            }
        }
        this.getLogger().info("Started server socket on port " + this.port);
        BungeeMaster javaPlugin = this;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)javaPlugin, () -> {
                        try (ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                             ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());){
                            Result result;
                            Packet packet;
                            try {
                                packet = (Packet)objectInputStream.readObject();
                            }
                            catch (EOFException e) {
                                if (objectOutputStream != null) {
                                    if (var5_9 != null) {
                                        try {
                                            objectOutputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            var5_9.addSuppressed(throwable);
                                        }
                                    } else {
                                        objectOutputStream.close();
                                    }
                                }
                                if (objectInputStream != null) {
                                    if (var3_5 != null) {
                                        try {
                                            objectInputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            var3_5.addSuppressed(throwable);
                                        }
                                    } else {
                                        objectInputStream.close();
                                    }
                                }
                                return;
                            }
                            if (!Arrays.equals(packet.getPassword(), this.uuid.toString().toCharArray())) {
                                result = new Result(PacketStatus.INVALID_PASSWORD);
                            } else if (!PacketDirection.BUNGEE_TO_SPIGOT.equals((Object)packet.getPacketDirection()) && !PacketDirection.BIDIRECTIONAL.equals((Object)packet.getPacketDirection())) {
                                result = new Result(PacketStatus.WRONG_DIRECTION);
                            } else {
                                Optional<PacketHandler> packetHandlerOptional = this.getPacketHandlers().stream().filter(packetHandler -> packetHandler.getPacketClass().isAssignableFrom(packet.getClass())).findFirst();
                                if (packetHandlerOptional.isPresent()) {
                                    result = packetHandlerOptional.get().handlePacket(packet, socket);
                                } else {
                                    result = new Result(PacketStatus.UNKNOWN_PACKET);
                                    this.getLogger().warning("No packet handler found for packet class: " + packet.getClass().getCanonicalName());
                                }
                            }
                            objectOutputStream.writeObject(result);
                        }
                        catch (EOFException e) {
                            this.getLogger().warning("Socket did not send a packet with itself.");
                            e.printStackTrace();
                        }
                        catch (IOException | ClassNotFoundException e) {
                            this.getLogger().info("Failed to handle packet");
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    this.getLogger().warning("Failed to accept packet");
                    e.printStackTrace();
                }
            }
        });
        try (Socket socket = this.connect();){
            boolean status = this.sendPacket(this.getInitialPacket(false), socket);
            if (status) {
                this.getLogger().info("Successfully connected to BungeeMaster on BungeeCord");
            } else {
                this.getLogger().warning("Did not receive true after sending initial packet to BungeeMaster on BungeeCord, connection issues?");
                this.lock();
            }
        }
        catch (IOException | PacketException e) {
            this.getLogger().warning("Failed to connect to BungeeMaster on BungeeCord at " + this.getCombinedHost());
            e.printStackTrace();
            this.lock();
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (this.locked || !this.heartbeatDone) {
                return;
            }
            this.heartbeatDone = false;
            long timestamp = System.currentTimeMillis();
            Long remoteTimestamp = this.attemptSendPacket(new HeartbeatPacket());
            this.heartbeatDone = true;
            if (remoteTimestamp == null) {
                return;
            }
            this.ping = remoteTimestamp - timestamp;
        }, 0L, (long)(this.bungeeMasterSpigotConfig.getHeartbeatSeconds() * 20));
        this.getCommand("bungeemaster").setExecutor((CommandExecutor)new BungeeMasterSpigotCommand(this));
    }

    public static BungeeMaster getBungeeMaster() {
        return bungeeMaster;
    }

    public void stop(String message) {
        this.getLogger().warning(message);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void loadConfig() {
        ConfigurationSection bungeeSection;
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (configuration.contains("bungee")) {
            bungeeSection = configuration.getConfigurationSection("bungee");
        } else {
            this.getLogger().warning("The section 'bungee' in the configuration is not found, defaults will be assumed. Delete the config file and restart to have a clean valid configuration file.");
            bungeeSection = configuration.createSection("bungee");
        }
        boolean serverPortAuto = configuration.getBoolean("port-automatic", true);
        int serverPort = configuration.getInt("port", 3112);
        String host = bungeeSection.getString("host");
        int port = bungeeSection.getInt("port");
        char[] password = bungeeSection.getString("password", "").toCharArray();
        int heartbeatSeconds = bungeeSection.getInt("heartbeat-seconds", 30);
        int reconnectAttempts = bungeeSection.getInt("reconnect-attempts", 7);
        this.bungeeMasterSpigotConfig = new BungeeMasterSpigotConfig(serverPortAuto, serverPort, host, port, password, heartbeatSeconds, reconnectAttempts);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getPort() {
        return this.port;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public InitialPacket getInitialPacket(boolean reconnection) {
        return new InitialPacket(this.getUuid(), this.port, this.minecraftPort, reconnection);
    }

    public BungeeMasterSpigotConfig getBungeeMasterSpigotConfig() {
        return this.bungeeMasterSpigotConfig;
    }

    public String getCombinedHost() {
        return String.format("%s:%d", this.bungeeMasterSpigotConfig.getHost(), this.bungeeMasterSpigotConfig.getPort());
    }

    public Socket connect() throws IOException {
        return new Socket(this.bungeeMasterSpigotConfig.getHost(), this.bungeeMasterSpigotConfig.getPort());
    }

    public <R> R attemptSendPacket(Packet<R> packet) {
        try {
            return this.sendPacket(packet, this.connect());
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to send packet, attempting reconnect and trying again");
            e.printStackTrace();
            Socket socket = this.attemptReconnect();
            if (socket != null) {
                this.getLogger().info("Reconnect successful, attempting to send packet again");
                try {
                    return this.sendPacket(packet, socket);
                }
                catch (PacketException e1) {
                    this.getLogger().warning("Failed to send packet");
                    e1.printStackTrace();
                }
            }
        }
        catch (PacketException e) {
            this.getLogger().warning("Failed to send packet");
            e.printStackTrace();
        }
        return null;
    }

    public <R> R sendPacket(Packet<R> packet, Socket socket) throws PacketException {
        Object object;
        if (this.bungeeMasterSpigotConfig.getPassword().length != 0) {
            packet.setPassword(this.bungeeMasterSpigotConfig.getPassword());
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(packet);
        }
        catch (IOException e) {
            throw new PacketException("Failed to write packet", e);
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            object = objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PacketException("Failed to read result of packet", e);
        }
        if (object == null) {
            throw new PacketException("Result is null");
        }
        Result result = (Result)object;
        PacketStatus packetStatus = result.getPacketStatus();
        if (packetStatus == null || !packetStatus.isSuccess()) {
            throw new PacketException("Packet result status is " + (Object)((Object)packetStatus));
        }
        if (packet.isReturning()) {
            Object resultObject = result.getObject();
            if (!packet.getReturningClass().isAssignableFrom(resultObject.getClass())) {
                throw new PacketException(String.format("Returning object from packet of type %s is not of type %s", packet.getName(), packet.getReturningClass().getCanonicalName()));
            }
            return (R)resultObject;
        }
        return null;
    }

    public Socket attemptReconnect() {
        this.getLogger().warning(String.format("Attempting to reconnect with %d attempts", this.bungeeMasterSpigotConfig.getReconnectAttempts()));
        IOException latestThrowable = null;
        for (int attempts = 0; attempts <= this.bungeeMasterSpigotConfig.getReconnectAttempts(); ++attempts) {
            try {
                return this.connect();
            }
            catch (IOException e1) {
                latestThrowable = e1;
                continue;
            }
        }
        this.getLogger().warning(String.format("Failed to reconnect to BungeeMaster on BungeeCord after %d attempts", this.bungeeMasterSpigotConfig.getReconnectAttempts()));
        if (latestThrowable != null) {
            latestThrowable.printStackTrace();
        }
        this.lock();
        return null;
    }

    public void lock() {
        this.locked = true;
        this.getLogger().warning("Addon will not work properly until '/bungeemaster reconnect' is ran. To reload the configuration run '/bungeemaster reload'.");
    }

    public long getPing() {
        return this.ping;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public List<PacketHandler<?>> getPacketHandlers() {
        return this.packetHandlers;
    }

    public String[] addAddonPrefix(String[] syntaxes) {
        return (String[])Arrays.stream(syntaxes).map(syntax -> "[(bm|bungeemaster)] " + syntax).toArray(String[]::new);
    }

    public void registerEffect(Class<? extends Effect> effect) {
        if (!effect.isAnnotationPresent(Documentation.class)) {
            throw new RegistrationException("Effect class: " + effect.getCanonicalName() + " does not have a Documentation annotation");
        }
        Documentation documentation = effect.getDeclaredAnnotation(Documentation.class);
        Skript.registerEffect(effect, (String[])this.addAddonPrefix(documentation.syntax()));
    }

    public void registerExpression(Class<? extends Expression> expression, ExpressionType expressionType) {
        if (!expression.isAnnotationPresent(Documentation.class)) {
            throw new RegistrationException("Expression class: " + expression.getCanonicalName() + " does not have a Documentation annotation");
        }
        Documentation documentation = expression.getDeclaredAnnotation(Documentation.class);
        Skript.registerExpression(expression, (Class)this.getGenericType(expression, 0), (ExpressionType)expressionType, (String[])this.addAddonPrefix(documentation.syntax()));
    }

    public Class getGenericType(Class clazz, int index) {
        return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[index];
    }

    public String[] convertObjectsToNamesAndUUIDs(Object[] objects) {
        return (String[])Arrays.stream(objects).map(obj -> {
            if (obj instanceof Player) {
                return ((Player)obj).getName();
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            return null;
        }).filter(Objects::nonNull).toArray(String[]::new);
    }

    public static class RegistrationException
    extends RuntimeException {
        public RegistrationException() {
        }

        public RegistrationException(String message) {
            super(message);
        }

        public RegistrationException(String message, Throwable cause) {
            super(message, cause);
        }

        public RegistrationException(Throwable cause) {
            super(cause);
        }
    }
}

