/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.bungee.handlers;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.tonymaster21.bungeemaster.bungee.BungeeMaster;
import me.tonymaster21.bungeemaster.bungee.handlers.BungeeActionPacketHandler;
import me.tonymaster21.bungeemaster.packets.Result;
import me.tonymaster21.bungeemaster.packets.spigot.ProxyCommandPacket;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;

public class ProxyCommandPacketHandler
extends BungeeActionPacketHandler<ProxyCommandPacket> {
    public ProxyCommandPacketHandler(Class<ProxyCommandPacket> packetClass, BungeeMaster bungeeMaster) {
        super(packetClass, bungeeMaster);
    }

    @Override
    public Result handlePacket(ProxyCommandPacket packet, Socket socket) {
        String command = packet.getCommand();
        if (command == null) {
            return this.getErrorResult("Command is null");
        }
        CommandSender commandSender = this.getBungeeMaster().getProxy().getConsole();
        if (packet.isOutput()) {
            RecordingCommandSender recordingCommandSender = new RecordingCommandSender(commandSender);
            this.getBungeeMaster().getProxy().getPluginManager().dispatchCommand((CommandSender)recordingCommandSender, command);
            List<String> messages = recordingCommandSender.getMessages();
            return this.getSuccessfulResult(messages.toArray());
        }
        this.getBungeeMaster().getProxy().getPluginManager().dispatchCommand(commandSender, command);
        return this.getSuccessfulResult();
    }

    public static class RecordingCommandSender
    implements CommandSender {
        private List<String> messages = new ArrayList<String>();
        private CommandSender commandSender;

        public RecordingCommandSender(CommandSender commandSender) {
            this.commandSender = commandSender;
        }

        public String getName() {
            return this.commandSender.getName();
        }

        public void sendMessage(String message) {
            this.messages.add(message);
            this.commandSender.sendMessage(message);
        }

        public void sendMessages(String ... messages) {
            this.messages.addAll(Arrays.asList(messages));
            this.commandSender.sendMessages(messages);
        }

        public void sendMessage(BaseComponent ... message) {
            this.messages.addAll(Arrays.stream(message).map(baseComponent -> baseComponent.toLegacyText()).collect(Collectors.toList()));
            this.commandSender.sendMessage(message);
        }

        public void sendMessage(BaseComponent message) {
            this.messages.add(message.toLegacyText());
            this.commandSender.sendMessage(message);
        }

        public Collection<String> getGroups() {
            return this.commandSender.getGroups();
        }

        public void addGroups(String ... groups) {
            this.commandSender.addGroups(groups);
        }

        public void removeGroups(String ... groups) {
            this.commandSender.removeGroups(groups);
        }

        public boolean hasPermission(String permission) {
            return this.commandSender.hasPermission(permission);
        }

        public void setPermission(String permission, boolean value) {
            this.commandSender.setPermission(permission, value);
        }

        public Collection<String> getPermissions() {
            return this.commandSender.getPermissions();
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

