/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.bungee.handlers;

import java.net.InetSocketAddress;
import java.net.Socket;
import me.tonymaster21.bungeemaster.bungee.BungeeMaster;
import me.tonymaster21.bungeemaster.bungee.handlers.BungeeActionPacketHandler;
import me.tonymaster21.bungeemaster.packets.Result;
import me.tonymaster21.bungeemaster.packets.spigot.ConnectPlayerPacket;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ConnectPlayerPacketHandler
extends BungeeActionPacketHandler<ConnectPlayerPacket> {
    public ConnectPlayerPacketHandler(Class<ConnectPlayerPacket> packetClass, BungeeMaster bungeeMaster) {
        super(packetClass, bungeeMaster);
    }

    @Override
    public Result handlePacket(ConnectPlayerPacket packet, Socket socket) {
        ServerInfo serverInfo;
        String player = packet.getPlayer();
        if (player == null) {
            return this.getErrorResult("Player is null");
        }
        ProxiedPlayer proxiedPlayer = this.getBungeeMaster().getPlayer(player);
        if (proxiedPlayer == null) {
            return this.getErrorResult("Player " + player + " is not online");
        }
        String destination = packet.getDestination();
        if (destination == null) {
            return this.getErrorResult("Destination is null");
        }
        boolean remote = packet.isRemote();
        if (remote) {
            String[] split = destination.split(":");
            destination = split[0];
            int port = Integer.valueOf(split.length >= 2 ? split[1] : "25565");
            serverInfo = this.getBungeeMaster().getProxy().constructServerInfo(destination, InetSocketAddress.createUnresolved(destination, port), "", false);
        } else {
            serverInfo = this.getBungeeMaster().getProxy().getServerInfo(destination);
            if (serverInfo == null) {
                return this.getErrorResult("Invalid server name: " + destination);
            }
        }
        proxiedPlayer.connect(serverInfo);
        return this.getSuccessfulResult();
    }
}

