/*
 * Decompiled with CFR 0.152.
 */
package me.tonymaster21.bungeemaster.bungee;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import me.tonymaster21.bungeemaster.bungee.BMServer;
import me.tonymaster21.bungeemaster.bungee.BungeeMasterBungeeCommand;
import me.tonymaster21.bungeemaster.bungee.BungeeMasterBungeeConfig;
import me.tonymaster21.bungeemaster.bungee.handlers.BroadcastMessagePacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.BungeePacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.CollectBungeeDebugPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.ConnectPlayerPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.HeartbeatPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.InitialPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.KickAllPlayersPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.KickPlayerPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.ProxyCommandPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.RetrieveServerAddressPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.SendMessageAsPlayerPacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.SendMessagePacketHandler;
import me.tonymaster21.bungeemaster.bungee.handlers.StopProxyPacketHandler;
import me.tonymaster21.bungeemaster.org.bstats.bungeecord.Metrics;
import me.tonymaster21.bungeemaster.packets.Packet;
import me.tonymaster21.bungeemaster.packets.PacketDirection;
import me.tonymaster21.bungeemaster.packets.PacketHandler;
import me.tonymaster21.bungeemaster.packets.PacketStatus;
import me.tonymaster21.bungeemaster.packets.Result;
import me.tonymaster21.bungeemaster.packets.spigot.BroadcastMessagePacket;
import me.tonymaster21.bungeemaster.packets.spigot.CollectBungeeDebugPacket;
import me.tonymaster21.bungeemaster.packets.spigot.ConnectPlayerPacket;
import me.tonymaster21.bungeemaster.packets.spigot.HeartbeatPacket;
import me.tonymaster21.bungeemaster.packets.spigot.InitialPacket;
import me.tonymaster21.bungeemaster.packets.spigot.KickAllPlayersPacket;
import me.tonymaster21.bungeemaster.packets.spigot.KickPlayerPacket;
import me.tonymaster21.bungeemaster.packets.spigot.ProxyCommandPacket;
import me.tonymaster21.bungeemaster.packets.spigot.RetrieveServerAddressPacket;
import me.tonymaster21.bungeemaster.packets.spigot.SendMessageAsPlayerPacket;
import me.tonymaster21.bungeemaster.packets.spigot.SendMessagePacket;
import me.tonymaster21.bungeemaster.packets.spigot.StopProxyPacket;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeMaster
extends Plugin {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}");
    private File configFile;
    private volatile BungeeMasterBungeeConfig config;
    private ServerSocket serverSocket;
    private List<PacketHandler<?>> packetHandlers = new ArrayList<BungeePacketHandler>(Arrays.asList(new InitialPacketHandler(InitialPacket.class, this), new HeartbeatPacketHandler(HeartbeatPacket.class, this), new CollectBungeeDebugPacketHandler(CollectBungeeDebugPacket.class, this), new SendMessageAsPlayerPacketHandler(SendMessageAsPlayerPacket.class, this), new ConnectPlayerPacketHandler(ConnectPlayerPacket.class, this), new KickAllPlayersPacketHandler(KickAllPlayersPacket.class, this), new KickPlayerPacketHandler(KickPlayerPacket.class, this), new BroadcastMessagePacketHandler(BroadcastMessagePacket.class, this), new SendMessagePacketHandler(SendMessagePacket.class, this), new StopProxyPacketHandler(StopProxyPacket.class, this), new ProxyCommandPacketHandler(ProxyCommandPacket.class, this), new RetrieveServerAddressPacketHandler(RetrieveServerAddressPacket.class, this)));
    private volatile Map<UUID, BMServer> serverMap = new HashMap<UUID, BMServer>();
    private volatile Map<String, UUID> serverUUIDMap = new HashMap<String, UUID>();

    public void onEnable() {
        new Metrics(this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.loadConfig();
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeMasterBungeeCommand(this));
        BungeeMaster plugin = this;
        try {
            this.serverSocket = new ServerSocket(this.config.getPort(), 50, this.config.getInetAddressHost());
            this.getLogger().info("Successfully started BungeeMaster on BungeeCord on " + this.getCombinedHost());
            this.getProxy().getScheduler().runAsync((Plugin)this, () -> {
                try {
                    while (!this.serverSocket.isClosed()) {
                        Socket socket = this.serverSocket.accept();
                        this.getProxy().getScheduler().runAsync(plugin, () -> {
                            try (ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());){
                                Result result;
                                Packet packet;
                                try {
                                    packet = (Packet)objectInputStream.readObject();
                                }
                                catch (EOFException e) {
                                    if (objectOutputStream != null) {
                                        if (var5_9 != null) {
                                            try {
                                                objectOutputStream.close();
                                            }
                                            catch (Throwable throwable) {
                                                var5_9.addSuppressed(throwable);
                                            }
                                        } else {
                                            objectOutputStream.close();
                                        }
                                    }
                                    if (objectInputStream != null) {
                                        if (var3_5 != null) {
                                            try {
                                                objectInputStream.close();
                                            }
                                            catch (Throwable throwable) {
                                                var3_5.addSuppressed(throwable);
                                            }
                                        } else {
                                            objectInputStream.close();
                                        }
                                    }
                                    return;
                                }
                                if (this.getConfig().getPassword().length != 0 && !Arrays.equals(this.getConfig().getPassword(), packet.getPassword())) {
                                    result = new Result(PacketStatus.INVALID_PASSWORD);
                                } else if (!PacketDirection.SPIGOT_TO_BUNGEE.equals((Object)packet.getPacketDirection()) && !PacketDirection.BIDIRECTIONAL.equals((Object)packet.getPacketDirection())) {
                                    result = new Result(PacketStatus.WRONG_DIRECTION);
                                } else {
                                    Optional<PacketHandler> packetHandlerOptional = this.getPacketHandlers().stream().filter(packetHandler -> packetHandler.getPacketClass().isAssignableFrom(packet.getClass())).findFirst();
                                    if (packetHandlerOptional.isPresent()) {
                                        result = packetHandlerOptional.get().handlePacket(packet, socket);
                                    } else {
                                        result = new Result(PacketStatus.UNKNOWN_PACKET);
                                        this.getLogger().warning("No packet handler found for packet class: " + packet.getClass().getCanonicalName());
                                    }
                                }
                                objectOutputStream.writeObject(result);
                            }
                            catch (EOFException e) {
                                this.getLogger().warning("Socket did not send a packet with itself.");
                                e.printStackTrace();
                            }
                            catch (IOException | ClassNotFoundException e) {
                                this.getLogger().info("Failed to handle packet");
                                e.printStackTrace();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    this.getLogger().warning("Failed to accept socket");
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadConfig() {
        try {
            if (!this.configFile.exists()) {
                Files.copy(this.getResourceAsStream("bungee/config.yml"), this.configFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to copy default configuration");
            e.printStackTrace();
        }
        try {
            Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.configFile);
            String host = configuration.getString("host", "0.0.0.0");
            int port = configuration.getInt("port", 2112);
            char[] password = configuration.getString("password", "").toCharArray();
            InetAddress inetAddressHost = null;
            try {
                inetAddressHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                this.getLogger().warning("Invalid host: " + host);
                e.printStackTrace();
            }
            if (inetAddressHost == null) {
                inetAddressHost = InetAddress.getByName("0.0.0.0");
            }
            this.config = new BungeeMasterBungeeConfig(host, inetAddressHost, port, password);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to load configuration");
            e.printStackTrace();
        }
    }

    public BungeeMasterBungeeConfig getConfig() {
        return this.config;
    }

    public String getCombinedHost() {
        return String.format("%s:%d", this.getConfig().getHost(), this.getConfig().getPort());
    }

    public List<PacketHandler<?>> getPacketHandlers() {
        return this.packetHandlers;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public ProxiedPlayer getPlayer(String representation) {
        if (UUID_PATTERN.matcher(representation).matches()) {
            UUID uuid = UUID.fromString(representation);
            ProxiedPlayer player = this.getProxy().getPlayer(uuid);
            if (player != null) {
                return player;
            }
        }
        return this.getProxy().getPlayer(representation);
    }

    public Map<UUID, BMServer> getServerMap() {
        return this.serverMap;
    }

    public Map<String, UUID> getServerUUIDMap() {
        return this.serverUUIDMap;
    }

    public BMServer getServerByUUID(UUID uuid) {
        return this.serverMap.get(uuid);
    }

    public BMServer getServerByName(String name) {
        return this.getServerByUUID(this.serverUUIDMap.get(name));
    }

    public BMServer getServerByServerInfo(ServerInfo serverInfo) {
        return this.getServerByName(serverInfo.getName());
    }
}

