/*
 * Decompiled with CFR 0.152.
 */
package com.wh1lec0d3r_.bunchsk.core.client;

import com.wh1lec0d3r_.bunchsk.core.client.config.ConfigData;
import com.wh1lec0d3r_.bunchsk.core.client.packet.PacketManager;
import com.wh1lec0d3r_.bunchsk.core.client.packet.YPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.bukkit.Bukkit;

public class CoreClient
extends Thread {
    private ConfigData configData;
    private Socket socket;

    public CoreClient(ConfigData configData) {
        System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Loading");
        this.configData = configData;
        System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Connecting to server socket");
        this.openSocket(configData.getHost(), configData.getPort());
        System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Authorizing");
        this.authorize();
    }

    private void authorize() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getSocket().getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.getSocket().getOutputStream());
            dataOutputStream.writeUTF(Bukkit.getWorldContainer().getCanonicalFile().getName());
            dataOutputStream.writeUTF(this.getConfigData().getPassword());
            dataOutputStream.writeInt(this.getConfigData().getHashId());
            boolean auth = dataInputStream.readBoolean();
            if (auth) {
                System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Authorized");
                System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Starting \u00c2\u00bb Thread \u00c2\u00bb Reading data");
                this.start();
            } else {
                System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Error on authorize");
            }
        }
        catch (IOException ex) {
            System.out.println("\u00e2\u2013\u02c6 Client Error on authorize: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void openSocket(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Connected to socket");
        }
        catch (IOException e) {
            System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Error on connecting to socket: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        while (!this.getSocket().isClosed()) {
            try {
                DataInputStream dataInputStream = new DataInputStream(this.getSocket().getInputStream());
                short id = dataInputStream.readShort();
                YPacket yPacket = PacketManager.getPacket(id);
                if (yPacket != null) {
                    yPacket.read(dataInputStream);
                    yPacket.handle();
                }
                Thread.sleep(10L);
            }
            catch (IOException | InterruptedException ex) {
                try {
                    this.getSocket().close();
                }
                catch (IOException e) {
                    System.out.println("\u00e2\u2013\u02c6 Client \u00c2\u00bb Error on reading data: " + e.getMessage());
                }
                this.stop();
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ConfigData getConfigData() {
        return this.configData;
    }
}

