/*
 * Decompiled with CFR 0.152.
 */
package com.wh1lec0d3r_.bunchsk.core.api.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    public static HashEnum getEnumById(int id) {
        HashEnum[] hashEnumArray = HashEnum.values();
        int n = hashEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            HashEnum hashEnum = hashEnumArray[n2];
            if (hashEnum.getId() == id) {
                return hashEnum;
            }
            ++n2;
        }
        return null;
    }

    public static String getHash(HashEnum hashEnum, String toHash) {
        String hash = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashEnum.getName());
            messageDigest.update(toHash.getBytes());
            byte[] bytes = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte aByte = byArray[n2];
                stringBuilder.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
                ++n2;
            }
            hash = stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return hash;
    }

    public static boolean validate(HashEnum hashEnum, String first, String second) {
        return Hash.getHash(hashEnum, first).equals(Hash.getHash(hashEnum, second));
    }

    public static enum HashEnum {
        MD5("MD5", 1),
        SHA1("SHA-1", 2),
        SHA256("SHA-256", 3),
        SHA384("SHA-384", 4),
        SHA512("SHA-512", 5);

        private final String name;
        private final int id;

        private HashEnum(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

