/*
 * Decompiled with CFR 0.152.
 */
package com.offline.bunchsk.core.server;

import com.offline.bunchsk.core.server.ClientHandler;
import com.offline.bunchsk.core.server.config.ConfigData;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;

public class CoreServer {
    private static CoreServer coreServer;
    private File configFile = new File("config.json");
    private ConfigData configData;
    private ServerSocket serverSocket;
    private Map<Socket, ClientHandler> clients;
    private HashMap<String, Object> vars;

    public CoreServer() {
        System.out.println("");
        System.out.println("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
        System.out.println("\u2588\u2500\u2500\u2500\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2500\u2500\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2500\u2500\u2588\u2500\u2588\u2588\u2500\u2588");
        System.out.println("\u2588\u2500\u2588\u2588\u2500\u2500\u2588\u2500\u2588\u2500\u2588\u2500\u2500\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2588\u2500\u2588\u2500\u2588\u2588");
        System.out.println("\u2588\u2500\u2500\u2500\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2500\u2588\u2500\u2500\u2588\u2500\u2588\u2588\u2588\u2588\u2500\u2500\u2500\u2500\u2588\u2588\u2500\u2500\u2500\u2588\u2500\u2500\u2588\u2588\u2588");
        System.out.println("\u2588\u2500\u2588\u2588\u2500\u2500\u2588\u2500\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2588\u2588\u2500\u2588\u2500\u2588\u2500\u2588\u2588");
        System.out.println("\u2588\u2500\u2500\u2500\u2500\u2588\u2588\u2500\u2500\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2500\u2500\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2500\u2500\u2588\u2500\u2588\u2588\u2500\u2588");
        System.out.println("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
        System.out.println("");
        coreServer = this;
        this.clients = new HashMap<Socket, ClientHandler>();
        this.vars = new HashMap();
        System.out.println("\u2588 Loading \u00bb Config");
        this.loadConfig();
        System.out.println("\u2588 Opening \u00bb ServerSocket");
        this.openSocket(this.getConfigData().getPort());
        System.out.println("\u2588 Starting \u00bb Thread \u00bb Read connections");
        this.startReadConnections();
        System.out.println("\u2588 Starting \u00bb Thread \u00bb Read console");
        this.startReadConsole();
    }

    private void openSocket(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            System.out.println("\u2588 Socket \u00bb Server successefully opened!");
        }
        catch (IOException e) {
            System.out.println("\u2588 Socket \u00bb Error on opening server.");
            e.printStackTrace();
        }
    }

    private void startReadConnections() {
        Thread readConnectionsThread = new Thread(() -> {
            while (!this.getServerSocket().isClosed()) {
                try {
                    Socket socket = this.getServerSocket().accept();
                    System.out.println("\u2588 Client \u00bb New client connected");
                    this.clients.put(socket, new ClientHandler(socket, this));
                    Thread.sleep(10L);
                }
                catch (IOException | InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
        readConnectionsThread.start();
    }

    private void startReadConsole() {
        Thread readConsoleThread = new Thread(() -> {
            Scanner scanner = new Scanner(System.in);
            block20: while (scanner.hasNext()) {
                String line = scanner.nextLine();
                String[] args = line.split(" ");
                if (args.length == 0) continue;
                switch (args[0].toLowerCase()) {
                    case "help": {
                        System.out.println("\u2588 Command \u00bb Help command:");
                        System.out.println("\u2588   \u00bb Help - 'help'");
                        System.out.println("\u2588   \u00bb Shutdown core - 'end'");
                        System.out.println("\u2588   \u00bb List of clients - 'clients'");
                        break;
                    }
                    case "end": {
                        System.out.println("\u2588 Command \u00bb Shutdown core!");
                        System.exit(0);
                        break;
                    }
                    case "clients": {
                        if (args.length == 1) {
                            System.out.println("\u2588 Command \u00bb Help 'clients' command: ");
                            System.out.println("\u2588   \u00bb All clients - 'clients all'");
                            System.out.println("\u2588   \u00bb Connected clients - 'clients connected'");
                            System.out.println("\u2588   \u00bb Closed clients - 'clients closed'");
                        }
                        if (args.length <= 1) continue block20;
                        switch (args[1].toLowerCase()) {
                            case "all": {
                                System.out.println("\u2588 Command \u00bb Client all:");
                                System.out.println("\u2588   \u00bb Clients: " + this.getClients().size());
                                for (ClientHandler clientHandler : this.getClients().values()) {
                                    System.out.println("\u2588   \u00bb Client name: " + clientHandler.getHandlerName() + " Client IP: " + clientHandler.getSocket().getInetAddress().getHostAddress());
                                }
                                continue block20;
                            }
                            case "connected": {
                                LinkedList connected = new LinkedList();
                                this.getClients().entrySet().stream().filter(socketClientHandlerEntry -> ((ClientHandler)socketClientHandlerEntry.getValue()).isEnabled()).forEach(socketClientHandlerEntry -> connected.add(socketClientHandlerEntry.getValue()));
                                System.out.println("\u2588 Command \u00bb Client connected:");
                                System.out.println("\u2588   \u00bb Clients: " + connected.size());
                                for (ClientHandler clientHandler2 : connected) {
                                    System.out.println("\u2588   \u00bb Client name: " + clientHandler2.getHandlerName() + " Client IP: " + clientHandler2.getSocket().getInetAddress().getHostAddress());
                                }
                                continue block20;
                            }
                            case "closed": {
                                LinkedList linkedList = new LinkedList();
                                this.getClients().entrySet().stream().filter(socketClientHandlerEntry -> !((ClientHandler)socketClientHandlerEntry.getValue()).isEnabled()).forEach(socketClientHandlerEntry -> closed.add(socketClientHandlerEntry.getValue()));
                                System.out.println("\u2588 Command \u00bb Client connected:");
                                System.out.println("\u2588   \u00bb Clients: " + linkedList.size());
                                for (ClientHandler clientHandler : linkedList) {
                                    System.out.println("\u2588   \u00bb Client name: " + clientHandler.getHandlerName() + " Client IP: " + clientHandler.getSocket().getInetAddress().getHostAddress());
                                }
                                continue block20;
                            }
                            default: {
                                System.out.println("\u2588 Command \u00bb Help 'clients' command: ");
                                System.out.println("\u2588   \u00bb All clients - 'clients all'");
                                System.out.println("\u2588   \u00bb Connected clients - 'clients connected'");
                                System.out.println("\u2588   \u00bb Closed clients - 'clients closed'");
                                break;
                            }
                        }
                        continue block20;
                    }
                    default: {
                        System.out.println("\u2588 Command \u00bb Unknown command, type 'help' for help!");
                    }
                }
            }
        });
        readConsoleThread.start();
    }

    private void loadConfig() {
        if (this.getConfigFile().exists()) {
            System.out.println("\u2588 Config \u00bb Loading data from config file");
            this.configData = new ConfigData();
            this.configData = this.configData.readConfig(ConfigData.class);
        } else {
            System.out.println("\u2588 Config \u00bb Creating config file");
            this.configData = new ConfigData();
            this.configData.saveConfig();
        }
        System.out.println("\u2588 Config \u00bb Config loaded successefully");
    }

    public ConfigData getConfigData() {
        return this.configData;
    }

    private ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private Map<Socket, ClientHandler> getClients() {
        return this.clients;
    }

    public ClientHandler getClient(Socket socket) {
        return this.getClients().get(socket);
    }

    private HashMap<String, Object> getVars() {
        return this.vars;
    }

    public Object getVar(String key) {
        return this.getVars().get(key);
    }

    public void setVar(String key, Object value) {
        this.getVars().put(key, value);
    }

    private HashMap<String, Object> getConfigVars() {
        return this.getConfigData().getVars();
    }

    public Object getConfigVar(String key) {
        return this.getConfigVars().get(key);
    }

    public void setConfigVar(String key, Object value) {
        this.getConfigVars().put(key, value);
    }

    public void removeClientHandler(ClientHandler clientHandler) {
        clientHandler.setEnabled(false);
        try {
            clientHandler.getSocket().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (clientHandler.isAlive()) {
            clientHandler.stop();
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public static CoreServer getCoreServer() {
        return coreServer;
    }
}

