/*
 * Decompiled with CFR 0.152.
 */
package com.offline.bunchsk.core.server;

import com.offline.bunchsk.core.api.utils.Hash;
import com.offline.bunchsk.core.server.CoreServer;
import com.offline.bunchsk.core.server.packet.PacketManager;
import com.offline.bunchsk.core.server.packet.YPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ClientHandler
extends Thread {
    private Socket socket;
    private CoreServer coreServer;
    private String name;
    private boolean enabled;

    ClientHandler(Socket socket, CoreServer coreServer) {
        System.out.println("\u2588 Client \u00bb Creating");
        this.socket = socket;
        this.coreServer = coreServer;
        System.out.println("\u2588 Client \u00bb Authorizing");
        this.authorize();
    }

    private void authorize() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getSocket().getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.getSocket().getOutputStream());
            String name = dataInputStream.readUTF();
            String password = dataInputStream.readUTF();
            int hashId = dataInputStream.readInt();
            this.name = name;
            boolean auth = Hash.validate(Hash.getEnumById(hashId), password, this.getCoreServer().getConfigData().getPassword());
            if (auth) {
                System.out.println("\u2588 Client \u00bb " + this.getHandlerName() + " \u00bb Authorized");
                System.out.println("\u2588 Client \u00bb " + this.getHandlerName() + " \u00bb Starting \u00bb Thread \u00bb Reading data");
                this.start();
                dataOutputStream.writeBoolean(true);
                dataOutputStream.flush();
            } else {
                System.out.println("\u2588 Client \u00bb " + this.getHandlerName() + " \u00bb Error on authorize: Password don't match");
                dataOutputStream.writeBoolean(false);
                dataOutputStream.flush();
            }
        }
        catch (IOException ex) {
            System.out.println("\u2588 Client \u00bb " + this.getHandlerName() + " \u00bb Error on authorize: " + ex.getMessage());
        }
    }

    @Override
    public void run() {
        while (!this.getSocket().isClosed()) {
            try {
                DataInputStream dataInputStream = new DataInputStream(this.getSocket().getInputStream());
                short id = dataInputStream.readShort();
                YPacket yPacket = PacketManager.getPacket(id);
                if (yPacket != null) {
                    yPacket.setSocket(this.getSocket());
                    yPacket.setClientHandler(this);
                    yPacket.read(dataInputStream);
                    yPacket.handle();
                }
                Thread.sleep(10L);
            }
            catch (IOException | InterruptedException e) {
                System.out.println("\u2588 Client \u00bb " + this.getHandlerName() + " \u00bb Error on reading packet: " + e.getMessage());
                this.getCoreServer().removeClientHandler(this);
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public CoreServer getCoreServer() {
        return this.coreServer;
    }

    public String getHandlerName() {
        return this.name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

