/*
 * Decompiled with CFR 0.152.
 */
package com.offline.bunchsk.core.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class PropertyBasesInterfaceMarshal
implements JsonSerializer<Object>,
JsonDeserializer<Object> {
    private static final String CLASS_META_KEY = "j_class";

    public JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonElement jsonElement = jsonSerializationContext.serialize(object, object.getClass());
        jsonElement.getAsJsonObject().addProperty(CLASS_META_KEY, object.getClass().getCanonicalName());
        return jsonElement;
    }

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String className = jsonObject.get(CLASS_META_KEY).getAsString();
        try {
            Class<?> clazz = Class.forName(className);
            return jsonDeserializationContext.deserialize(jsonElement, clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new JsonParseException((Throwable)ex);
        }
    }
}

