/*
 * Decompiled with CFR 0.152.
 */
package com.offline.bunchsk;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleEvent;
import com.offline.bunchsk.core.client.CoreClient;
import com.offline.bunchsk.core.client.config.ConfigData;
import com.offline.bunchsk.utils.ClassFinder;
import com.offline.bunchsk.utils.DocsGenerator;
import com.offline.bunchsk.utils.RegisterOptions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class BunchSk
extends JavaPlugin {
    static BunchSk bunchSk;
    private static String ADDON_TAG;
    private static boolean DEBUG_MODE;
    private static boolean NETWORK_INSTANCE;
    private ConfigData configData;
    private CoreClient coreClient;
    private File configFile = new File(this.getDataFolder(), "config.json");

    public void onEnable() {
        bunchSk = this;
        Skript.registerAddon((JavaPlugin)this);
        if (Skript.isAcceptRegistrations()) {
            try {
                this.registerElements();
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getLogger(BunchSk.class.getName()).log(Level.SEVERE, null, ex);
                System.out.println(this.tagged("Register \u00bb Failed to register stuff"));
            }
        } else {
            System.out.println(this.tagged("Register \u00bb Failed to register stuff"));
        }
        if (!NETWORK_INSTANCE) {
            this.coreClient = new CoreClient(this.configData);
        }
        this.loadConfig();
    }

    public void onDisable() {
    }

    private void loadConfig() {
        if (this.getConfigFile().exists()) {
            System.out.println(this.tagged("Config \u00bb Loading data from config file"));
            this.configData = new ConfigData();
            this.configData = this.configData.readConfig(ConfigData.class);
        } else {
            System.out.println(this.tagged("Client \u00bb Creating config file"));
            this.configData = new ConfigData();
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdir();
                }
                if (!this.getConfigFile().exists()) {
                    this.getConfigFile().createNewFile();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.configData.saveConfig();
        }
        System.out.println(this.tagged("Client \u00bb Config loaded successefully"));
    }

    public void registerElements() throws IOException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int effectCount = 0;
        int expressionCount = 0;
        int eventCount = 0;
        int conditionCount = 0;
        boolean checker = false;
        int deprecated = 0;
        DocsGenerator.createDocs();
        System.out.println(this.tagged("Starting \u00bb Registering stuff"));
        Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
        method.setAccessible(true);
        File file = (File)method.invoke((Object)this, new Object[0]);
        Set<Class<?>> classes = ClassFinder.getClasses(file, "com.offline.bunchsk");
        if (classes != null) {
            for (Class<?> clazz : classes) {
                RegisterOptions annotation;
                if (!clazz.isAnnotationPresent(RegisterOptions.class)) continue;
                RegisterOptions registerOptions = annotation = clazz.getAnnotation(RegisterOptions.class);
                checker = true;
                if (!Objects.equals(registerOptions.PluginDepend(), "None") && Bukkit.getPluginManager().getPlugin(registerOptions.PluginDepend()) == null) {
                    checker = false;
                }
                if (checker) {
                    switch (registerOptions.RegType()) {
                        case "EFFECT": {
                            Skript.registerEffect(clazz, (String[])registerOptions.Syntaxes());
                            ++effectCount;
                            DocsGenerator.writeDocs(registerOptions.Name(), registerOptions.Syntaxes(), "Effect");
                            break;
                        }
                        case "CONDITION": {
                            Skript.registerCondition(clazz, (String[])registerOptions.Syntaxes());
                            ++conditionCount;
                            DocsGenerator.writeDocs(registerOptions.Name(), registerOptions.Syntaxes(), "Condition");
                            break;
                        }
                        case "EVENT": {
                            Skript.registerEvent((String)registerOptions.Name(), SimpleEvent.class, clazz, (String[])registerOptions.Syntaxes());
                            ++eventCount;
                            DocsGenerator.writeDocs(registerOptions.Name(), registerOptions.Syntaxes(), "Event");
                            break;
                        }
                        case "EXPRESSION": {
                            Skript.registerExpression(clazz, (Class)registerOptions.ExprClass(), (ExpressionType)registerOptions.ExprType(), (String[])registerOptions.Syntaxes());
                            ++expressionCount;
                            DocsGenerator.writeDocs(registerOptions.Name(), registerOptions.Syntaxes(), "Expression");
                        }
                    }
                }
                if (!registerOptions.Deprecated()) continue;
                ++deprecated;
            }
            if (effectCount == 0 && expressionCount == 0 && eventCount == 0 && conditionCount == 0) {
                System.out.println(this.tagged("Register \u00bb Failed to register stuff"));
            } else {
                System.out.println(this.tagged("Register \u00bb Effects: " + effectCount));
                System.out.println(this.tagged("Register \u00bb Expressions: " + expressionCount));
                System.out.println(this.tagged("Register \u00bb Events: " + eventCount));
                System.out.println(this.tagged("Register \u00bb Conditions: " + conditionCount));
                if (deprecated != 0) {
                    System.out.println(this.tagged("Register \u00bb Deprecated Elements: " + conditionCount));
                }
            }
        }
    }

    public String tagged(String s) {
        return ADDON_TAG + s;
    }

    public ConfigData getConfigData() {
        return this.configData;
    }

    public static BunchSk getBunchSk() {
        return bunchSk;
    }

    public CoreClient getCoreClient() {
        return this.coreClient;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    static {
        ADDON_TAG = "\u2588 BunchSk \u00bb ";
        DEBUG_MODE = true;
        NETWORK_INSTANCE = true;
    }
}

