/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.util;

import io.github.bi0qaw.biosphere.util.VectorLib;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TrigLib {
    public static Number[] llen(Location[] l) {
        Number[] nums = new Number[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            nums[i] = tempLoc.clone().toVector().length();
            ++i;
        }
        return nums;
    }

    public static Location[] lneg(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().multiply(-1.0);
            ++i;
        }
        return locs;
    }

    public static Location[] offset(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().add(vect);
            ++i;
        }
        return locs;
    }

    public static Location[] coffset(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().add(x, y, z);
            ++i;
        }
        return locs;
    }

    public static Location[] vectorOffset(Location[] locations, Vector[] vectors) {
        Location[] offset = new Location[locations.length * vectors.length];
        int i = 0;
        for (Location l : locations) {
            for (Vector v : vectors) {
                offset[i] = l.clone().add(v);
                ++i;
            }
        }
        return offset;
    }

    public static Location[] mult(Location[] l, double p) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().multiply(p);
            ++i;
        }
        return locs;
    }

    public static Location[] lmult(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().toVector().multiply(vect).toLocation(tempLoc.getWorld());
            ++i;
        }
        return locs;
    }

    public static Location[] lnorm(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().toVector().normalize().toLocation(tempLoc.getWorld());
            ++i;
        }
        return locs;
    }

    public static Location[] relloc(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(vect);
            ++i;
        }
        return locs;
    }

    public static Number[] dotp(Location[] l, Location l2) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            nums[i] = tempLoc.clone().toVector().dot(vect);
            ++i;
        }
        return nums;
    }

    public static Number[] cdotp(Location[] l, double x, double y, double z) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        for (Location tempLoc : l) {
            nums[i] = tempLoc.clone().toVector().dot(vect);
            ++i;
        }
        return nums;
    }

    public static Location[] crossp(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().toVector().crossProduct(vect).toLocation(tempLoc.getWorld());
            ++i;
        }
        return locs;
    }

    public static Location[] ccrossp(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().toVector().crossProduct(vect).toLocation(tempLoc.getWorld());
            ++i;
        }
        return locs;
    }

    public static Location[] rot(Location[] l, Location center, Vector axis, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        double n1 = axis.getX();
        double n2 = axis.getY();
        double n3 = axis.getZ();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setX(x * (Math.pow(n1, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi)) + y * (n2 * n1 * (1.0 - Math.cos(phi)) - n3 * Math.sin(phi)) + z * (n1 * n3 * (1.0 - Math.cos(phi)) + n2 * Math.sin(phi)));
            locs[i].setY(x * (n1 * n2 * (1.0 - Math.cos(phi)) + n3 * Math.sin(phi)) + y * (Math.pow(n2, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi) + z * (n2 * n3 * (1.0 - Math.cos(phi)) - n1 * Math.sin(phi))));
            locs[i].setZ(x * (n3 * n1 * (1.0 - Math.cos(phi)) - n2 * Math.sin(phi)) + y * (n3 * n2 * (1.0 - Math.cos(phi)) + n1 * Math.sin(phi)) + z * (Math.pow(n3, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi)));
            ++i;
        }
        return TrigLib.offset(locs, center);
    }

    public static Location[] xrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect);
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setY(y * Math.cos(phi) + z * Math.sin(phi));
            locs[i].setZ(-y * Math.sin(phi) + z * Math.cos(phi));
            ++i;
        }
        return TrigLib.offset(locs, center);
    }

    public static Location[] yrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double z = locs[i].getZ();
            locs[i].setX(x * Math.cos(phi) - z * Math.sin(phi));
            locs[i].setZ(x * Math.sin(phi) + z * Math.cos(phi));
            locs[i].add(center);
            ++i;
        }
        return locs;
    }

    public static Location[] zrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double y = locs[i].getY();
            locs[i].setX(x * Math.cos(phi) + y * Math.sin(phi));
            locs[i].setY(-x * Math.sin(phi) + y * Math.cos(phi));
            ++i;
        }
        return TrigLib.offset(locs, center);
    }

    public static Location[] ptrefl(Location[] l, Location l2) {
        Vector vect = l2.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(vect).multiply(-1.0).add(vect);
            ++i;
        }
        return locs;
    }

    public static Location[] refl(Location[] l, Location point, Vector dir) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = point.clone().toVector();
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.toVector().subtract(vect).multiply(-1).multiply(dir).add(vect).toLocation(tempLoc.getWorld());
            ++i;
        }
        return locs;
    }

    public static Location[] scale(Location[] l, Location center, double d) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect).multiply(d).add(centerVect);
            ++i;
        }
        return locs;
    }

    public static Location[] dirscale(Location[] l, Location center, Vector dir, double d) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(center).toVector().multiply(d).multiply(dir).toLocation(tempLoc.getWorld()).add(center);
            ++i;
        }
        return locs;
    }

    public static Location[] cdirscale(Location[] l, Location center, double x, double y, double z) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().subtract(centerVect).toVector().multiply(vect).toLocation(tempLoc.getWorld()).add(centerVect);
            ++i;
        }
        return locs;
    }

    public static Location[] midpt(Location[] l) {
        Location loc = new Location(l[0].getWorld(), 0.0, 0.0, 0.0);
        for (Location tempLoc : l) {
            loc.add(tempLoc);
        }
        return new Location[]{loc.multiply(1.0 / (double)Array.getLength(l))};
    }

    public static Location[] sphloc(Location[] l, double phi, double the, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.sin(the) * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + r * Math.cos(the));
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(the) * Math.sin(phi));
            ++i;
        }
        return locs;
    }

    public static Location[] cylloc(Location[] l, double phi, double r, double h) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + h);
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(phi));
            ++i;
        }
        return locs;
    }

    public static Location[] cubeloc(Location[] l, Location l2, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * l2.getX() - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * l2.getY() - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * l2.getZ() - 1.0));
            ++i;
        }
        return locs;
    }

    public static Location[] ccubeloc(Location[] l, double x, double y, double z, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * x - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * y - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * z - 1.0));
            ++i;
        }
        return locs;
    }

    public static Location[] lineloc(Location[] l, Location l2, double p) {
        Vector vect = l2.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        for (Location tempLoc : l) {
            locs[i] = tempLoc.clone().add(vect.clone().subtract(tempLoc.clone().toVector()).multiply(p));
            ++i;
        }
        return locs;
    }

    public static Location[] getLine(Location[] l, Location l2, double d) {
        Vector vect = l2.clone().toVector();
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location tempLoc : l) {
            Vector tempVect = tempLoc.toVector();
            int k = (int)(tempVect.distance(vect) * d);
            Vector v = vect.clone().subtract(tempVect).multiply(1.0 / (double)k);
            for (int i = 0; i < k; ++i) {
                locs.add(tempLoc.clone().add(v.clone().multiply(i)));
            }
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public static Location[] linkAll(Location[] loc, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location l1 : loc) {
            for (Location l2 : loc) {
                if (l1.equals((Object)l2)) continue;
                locs.addAll(Arrays.asList(TrigLib.getLine(new Location[]{l1}, l2, d)));
            }
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public static Location[] getPoly(Location[] l, int n, double r) {
        double phi = Math.PI * 2 / (double)n;
        Location[] locs = new Location[n * Array.getLength(l)];
        int i = 0;
        int j = 0;
        for (Location tempLoc : l) {
            Location loc = tempLoc.clone().add(r, 0.0, 0.0);
            for (i = 0; i < n; ++i) {
                locs[j] = TrigLib.yrot(new Location[]{loc}, tempLoc, (double)i * phi)[0];
                ++j;
            }
        }
        return locs;
    }

    public static Location[] getPolyOutline(Location[] l, Integer n, double r, double d) {
        Location[] loc = new Location[n.intValue()];
        ArrayList<Location> locs = new ArrayList<Location>();
        int i = 0;
        for (Location tempLoc : l) {
            loc = TrigLib.getPoly(new Location[]{tempLoc}, n, r);
            for (i = 0; i < n - 1; ++i) {
                locs.addAll(Arrays.asList(TrigLib.getLine(new Location[]{loc[i]}, loc[i + 1], d)));
            }
            locs.addAll(Arrays.asList(TrigLib.getLine(new Location[]{loc[i]}, loc[0], d)));
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public static Location[] getHelix(Location[] l, double r, double h, double k, double d) {
        int n = (int)(h * 2.0 * Math.PI * r * d);
        double dphi = 1.0 / (k * r * d);
        Location[] locs = new Location[n * Array.getLength(l)];
        int i = 0;
        int j = 0;
        for (Location tempLoc : l) {
            for (j = 0; j < n; ++j) {
                locs[i] = TrigLib.cylloc(new Location[]{tempLoc}, (double)j * dphi, r, (double)j * h / (double)n)[0];
                ++i;
            }
        }
        return locs;
    }

    public static Location[] getCube(Location[] l, double r) {
        return TrigLib.vectorOffset(l, VectorLib.getCube(r));
    }

    public static Location[] getCubeOutline(Location[] l, double r, double d) {
        return TrigLib.vectorOffset(l, VectorLib.getCubeOutline(r, d));
    }

    public static Location[] getSphereRand(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int n = (int)(Math.PI * 4 * r * r * d);
        double phi = 0.0;
        double the = 0.0;
        Random randGen = new Random();
        for (Location tempLoc : l) {
            for (int i = 0; i < n; ++i) {
                phi = randGen.nextDouble() * 2.0 * Math.PI;
                the = randGen.nextDouble() * Math.PI;
                locs.add(TrigLib.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
            }
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public static Location[] getSphere(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        double the = 0.0;
        double phi = 0.0;
        int n = (int)(Math.PI * r * d);
        for (Location tempLoc : l) {
            the = 0.0;
            for (int i = 0; i < n; ++i) {
                phi = 0.0;
                for (int j = 0; j < n * 2; ++j) {
                    locs.add(TrigLib.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
                    phi += Math.PI / (double)n;
                }
                the += Math.PI / (double)n;
            }
        }
        return locs.toArray(new Location[locs.size()]);
    }
}

