/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Offset")
@Description(value={"Adds each offset to all vectors"})
@Examples(value={"#creates a 8 circles on the vertices of a cube and displays them with particles around the player", "set {_cube::*} to cube with radius 3", "set {_circle::*} to circle with radius 2 and density 5", "set {_cube-circles::*} to vectors {_cube::*} offset by {_circle::*}", "show happy villager at player offset by {_cube-circles::*}"})
public class ExprVectorOffset
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Vector> offsets;

    protected Vector[] get(Event event) {
        return VectorLib.offset((Vector[])this.vectors.getArray(event), (Vector[])this.offsets.getArray(event));
    }

    public boolean isSingle() {
        return this.vectors.isSingle() && this.offsets.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return "vector " + this.vectors.toString(event, b) + " offset by " + this.offsets.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vectors = expressions[0];
        this.offsets = expressions[1];
        return true;
    }
}

