/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Box Outline")
@Description(value={"Creates a list of vectors in the shape of a box including corners and edges. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_boxoutline::*} to vector box outline between vector -2.5, -2.5, -2.5 and vector 2.5, 2.5, 2.5 with density 5", "show happy villager at player's head offset by {_boxoutline::*}"})
public class ExprVectorBoxOutline
extends SimpleExpression<Vector> {
    private Expression<Vector> vector1;
    private Expression<Vector> vector2;
    private Expression<Number> density;

    protected Vector[] get(Event event) {
        return VectorLib.getBoxOutline((Vector)this.vector1.getSingle(event), (Vector)this.vector2.getSingle(event), ((Number)this.density.getSingle(event)).doubleValue());
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return "vector box outline between " + this.vector1.toString(event, b) + " and " + this.vector2.toString(event, b) + " with density " + this.density.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vector1 = expressions[0];
        this.vector2 = expressions[1];
        this.density = expressions[2];
        return true;
    }
}

