/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Box")
@Description(value={"Creates a list of vectors in the shape of a box (only the corners!)."})
@Examples(value={"set {_box::*} to vector box between vector -2.5, -2.5, -2.5 and vector 2.5, 2.5, 2.5", "show happy villager at player's head offset by {_box::*}"})
public class ExprVectorBox
extends SimpleExpression<Vector> {
    private Expression<Vector> vector1;
    private Expression<Vector> vector2;

    protected Vector[] get(Event event) {
        return VectorLib.getBox((Vector)this.vector1.getSingle(event), (Vector)this.vector2.getSingle(event));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return "vector box between " + this.vector1.toString(event, b) + " and " + this.vector2.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vector1 = expressions[0];
        this.vector2 = expressions[1];
        return true;
    }
}

