/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import io.github.bi0qaw.biosphere.util.VectorMath;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Sphere Coordinate")
@Description(value={"Gives locations in a spherical coordinate system."})
@Examples(value={"set {_loc} to spherical coordinate at player with radius 3, yaw 90 and pitch -45", "show happy villager at {_loc}", "#shows a particle at the location 3 in the negative x direction (because of yaw = 90) and a little bit above the player (because of pitch = -45)"})
public class ExprLocationSphereLoc
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> radius;
    private Expression<Number> yaw;
    private Expression<Number> pitch;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.radius = expr[1];
        this.yaw = expr[2];
        this.pitch = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "sphere coordinate at " + this.locations.toString(arg0, arg1) + " with radius " + this.radius.toString(arg0, arg1) + ", yaw " + this.yaw.toString(arg0, arg1) + " and pitch " + this.pitch.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        float y = ((Number)this.yaw.getSingle(e)).floatValue();
        float p = ((Number)this.pitch.getSingle(e)).floatValue();
        y = VectorMath.fromSkriptYaw(y);
        y = VectorMath.wrapYaw(y + 180.0f);
        p = VectorMath.fromSkriptPitch(p);
        p = VectorMath.wrapPitch(p);
        return LocationLib.getSphericalCoordinates((Location[])this.locations.getArray(e), r, y, p -= 90.0f);
    }
}

