/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Rotate XYZ")
@Description(value={"Rotates locations around a rotation center and rotation axis by an angle."})
@Examples(value={"set {_point} to location 5 in front of player", "set {_point} to {_point} rotated around y-axis at player with angle 180"})
public class ExprLocationRotXYZ
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Location> center;
    private Expression<Number> angle;
    private int axis;
    private String[] axisStr = new String[]{"x", "y", "z"};

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.locations = expr[0];
        this.center = expr[1];
        this.angle = expr[2];
        this.axis = parseResult.mark;
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return this.locations.toString(e, arg1) + " rotated around " + this.axisStr[this.axis] + "-axis at " + this.center.toString(e, arg1) + " with angle " + this.angle.toString(e, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        float a = ((Number)this.angle.getSingle(e)).floatValue();
        a = -a;
        if (this.axis == 1) {
            return LocationLib.rotateX((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), a);
        }
        if (this.axis == 2) {
            return LocationLib.rotateY((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), a);
        }
        return LocationLib.rotateZ((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), a);
    }
}

