/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Location Reflection")
@Description(value={"Mirrors locations in another location. The direction parameter applies an additional scaling for each axis."})
@Examples(value={"set {_point} to location 5 in front of player mirrored at player", "show happy villager at {_point}", "#shows a particle 5 blocks behind the player"})
public class ExprLocationReflection
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Location> point;
    private Expression<Vector> direction;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.locations = expr[0];
        this.point = expr[1];
        this.direction = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        if (this.direction == null) {
            return this.locations.toString(e, arg1) + " reflected at " + this.point.toString(e, arg1);
        }
        return this.locations.toString(e, arg1) + " reflected at " + this.point.toString(e, arg1) + " in direction " + this.direction.toString(e, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        if (this.direction == null) {
            return LocationLib.pointReflection((Location[])this.locations.getArray(e), (Location)this.point.getSingle(e));
        }
        return LocationLib.reflection((Location[])this.locations.getArray(e), (Location)this.point.getSingle(e), (Vector)this.direction.getSingle(e));
    }
}

