/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Polygon Outline")
@Description(value={"Creates a list of locations in the shape of a polygon including corners and edges. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"show happy villager at polygon outline at player with 6 points, radius 3 and density 5"})
public class ExprLocationPolygonOutline
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> points;
    private Expression<Number> radius;
    private Expression<Number> density;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.points = expr[1];
        this.radius = expr[2];
        this.density = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    @Nullable
    protected Location[] get(Event e) {
        int p = ((Number)this.points.getSingle(e)).intValue();
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return LocationLib.getPolygonOutline((Location[])this.locations.getArray(e), p, r, d);
    }
}

