/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Box")
@Description(value={"Creates a list of locations in the shape of a box (only the corners!)."})
@Examples(value={"set {_box::*} to box between player and location 5 right, 5 in front and 5 above player", "show happy villager at {_box::*}"})
public class ExprLocationBox
extends SimpleExpression<Location> {
    private Expression<Location> location1;
    private Expression<Location> location2;

    protected Location[] get(Event event) {
        return LocationLib.getBox((Location)this.location1.getSingle(event), (Location)this.location2.getSingle(event));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public String toString(Event event, boolean b) {
        return "box between " + this.location1.toString(event, b) + " and " + this.location2.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location1 = expressions[0];
        this.location2 = expressions[1];
        return true;
    }
}

