/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.Frame;
import io.github.bi0qaw.biosphere.util.VectorMath;
import org.bukkit.event.Event;

@Name(value="Frame from Yaw and Pitch")
@Description(value={"Creates a reference frame from a yaw and a pitch."})
@Examples(value={"set {_frame} to frame with yaw 90 and pitch -45", "set {_circle::*} to circle with radius 1 and density 5 in {_frame}", "show happy villager at player's head offset by {_circle::*}", "#shows a particle circle at the player's head with a yaw of 90 and pitch of -45"})
public class ExprFrameFromYawPitch
extends SimpleExpression<Frame> {
    Expression<Number> yaw;
    Expression<Number> pitch;

    protected Frame[] get(Event event) {
        float y = ((Number)this.yaw.getSingle(event)).floatValue();
        float p = ((Number)this.pitch.getSingle(event)).floatValue();
        y = VectorMath.fromSkriptYaw(y);
        p = VectorMath.fromSkriptPitch(p);
        y = VectorMath.wrapYaw(y);
        p = VectorMath.wrapPitch(p);
        return new Frame[]{new Frame().setFromYawPitch(y, p)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Frame> getReturnType() {
        return Frame.class;
    }

    public String toString(Event event, boolean b) {
        return "frame with yaw " + this.yaw.toString(event, b) + " and pitch " + this.pitch.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.yaw = expressions[0];
        this.pitch = expressions[1];
        return true;
    }
}

